/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.information;

import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.Type;

public class ChooseFunction
implements Function {
    public String getCanonicalName() {
        return "CHOOSE";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        if (parameters.getParameterCount() <= 2) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type indexType = parameters.getType(0);
        Object indexValue = parameters.getValue(0);
        int index = context.getTypeRegistry().convertToNumber(indexType, indexValue).intValue();
        if (index >= 1 && index < parameters.getParameterCount()) {
            return new TypeValuePair(parameters.getType(index), parameters.getValue(index));
        }
        throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
    }
}

