/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.math;

import java.math.BigDecimal;
import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.function.math.SumFunction;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.coretypes.NumberType;

public class AverageFunction
implements Function {
    public String getCanonicalName() {
        return "AVERAGE";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        SumFunction sumFunction = new SumFunction();
        TypeValuePair sum = sumFunction.evaluate(context, parameters);
        Number n = context.getTypeRegistry().convertToNumber(sum.getType(), sum.getValue());
        BigDecimal divident = new BigDecimal(n.toString());
        BigDecimal divisor = new BigDecimal(parameters.getParameterCount());
        BigDecimal avg = divident.divide(divisor, 4);
        return new TypeValuePair(NumberType.GENERIC_NUMBER, avg);
    }
}

