/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.math;

import java.math.BigDecimal;
import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.TypeConversionException;
import org.jfree.formula.typing.coretypes.NumberType;

public class SumFunction
implements Function {
    public static final BigDecimal ZERO = new BigDecimal(0);

    public String getCanonicalName() {
        return "SUM";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        BigDecimal computedResult = ZERO;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount == 0) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        for (int paramIdx = 0; paramIdx < parameterCount; ++paramIdx) {
            Object value = parameters.getValue(paramIdx);
            Type type = parameters.getType(paramIdx);
            if (value == null) continue;
            try {
                Number n = context.getTypeRegistry().convertToNumber(type, value);
                computedResult = this.compute(n, computedResult);
                continue;
            }
            catch (TypeConversionException tce) {
                // empty catch block
            }
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, computedResult);
    }

    private BigDecimal compute(Object value, BigDecimal computedResult) {
        if (value == null) {
            return computedResult;
        }
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException(String.valueOf(value));
        }
        if (value instanceof BigDecimal) {
            return computedResult.add((BigDecimal)value);
        }
        Number n = (Number)value;
        BigDecimal nval = new BigDecimal(n.toString());
        return computedResult.add(nval);
    }
}

