/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.text;

import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.function.text.MidFunction;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.formula.typing.coretypes.TextType;

public class ReplaceFunction
implements Function {
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount != 4) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Type newTextType = parameters.getType(3);
        Object newTextValue = parameters.getValue(3);
        Type textType = parameters.getType(0);
        Object textValue = parameters.getValue(0);
        Type startType = parameters.getType(1);
        Object startValue = parameters.getValue(1);
        Type lengthType = parameters.getType(2);
        Object lengthValue = parameters.getValue(2);
        String newText = typeRegistry.convertToText(newTextType, newTextValue);
        String text = typeRegistry.convertToText(textType, textValue);
        Number start = typeRegistry.convertToNumber(startType, startValue);
        Number length = typeRegistry.convertToNumber(lengthType, lengthValue);
        MidFunction function = new MidFunction();
        String result1 = function.process(text, new Integer(1), new Integer(start.intValue() - 1));
        String result2 = function.process(text, new Integer(start.intValue() + length.intValue()), new Integer(text.length()));
        StringBuffer buffer = new StringBuffer();
        buffer.append(result1);
        buffer.append(newText);
        buffer.append(result2);
        return new TypeValuePair(TextType.TYPE, buffer.toString());
    }

    public String getCanonicalName() {
        return "REPLACE";
    }
}

