/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.text;

import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.formula.typing.coretypes.TextType;

public class ReptFunction
implements Function {
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount != 2) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Type textType1 = parameters.getType(0);
        Object textValue1 = parameters.getValue(0);
        Type countType = parameters.getType(1);
        Object countValue = parameters.getValue(1);
        String text1 = typeRegistry.convertToText(textType1, textValue1);
        int count = typeRegistry.convertToNumber(countType, countValue).intValue();
        if (text1 == null && count >= 0) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            buffer.append(text1);
        }
        return new TypeValuePair(TextType.TYPE, buffer.toString());
    }

    public String getCanonicalName() {
        return "REPT";
    }
}

