/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.text;

import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.coretypes.TextType;

public class TrimFunction
implements Function {
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type type1 = parameters.getType(0);
        Object value1 = parameters.getValue(0);
        String result = context.getTypeRegistry().convertToText(type1, value1);
        if (result == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        char[] chars = result.toCharArray();
        StringBuffer b = new StringBuffer(chars.length);
        boolean removeNextWs = true;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isWhitespace(c)) {
                if (removeNextWs) continue;
                b.append(c);
                removeNextWs = true;
                continue;
            }
            b.append(c);
            removeNextWs = false;
        }
        String trimmedResult = removeNextWs ? b.substring(0, b.length() - 1) : b.toString();
        return new TypeValuePair(TextType.TYPE, trimmedResult);
    }

    public String getCanonicalName() {
        return "TRIM";
    }
}

