/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.text;

import java.io.UnsupportedEncodingException;
import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.coretypes.TextType;
import org.jfree.formula.util.URLEncoder;

public class URLEncodeFunction
implements Function {
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type textType = parameters.getType(0);
        Object textValue = parameters.getValue(0);
        String textResult = context.getTypeRegistry().convertToText(textType, textValue);
        if (textResult == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        String encodingResult = null;
        if (parameterCount == 2) {
            Type encodingType = parameters.getType(1);
            Object encodingValue = parameters.getValue(1);
            encodingResult = context.getTypeRegistry().convertToText(encodingType, encodingValue);
            if (encodingResult == null) {
                throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
        }
        try {
            if (encodingResult == null) {
                return new TypeValuePair(TextType.TYPE, URLEncoder.encode(textResult, "ISO-8859-1"));
            }
            return new TypeValuePair(TextType.TYPE, URLEncoder.encode(textResult, encodingResult));
        }
        catch (UnsupportedEncodingException use) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
    }

    public String getCanonicalName() {
        return "URLENCODE";
    }
}

