/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.lvalues;

import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.lvalues.DataTable;
import org.jfree.formula.lvalues.LValue;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.coretypes.DataTableType;
import org.jfree.util.ObjectTable;

public class DefaultDataTable
extends ObjectTable
implements DataTable {
    private transient Boolean constant;

    public DefaultDataTable() {
    }

    public DefaultDataTable(LValue[][] array) {
        if (array != null && array.length > 0) {
            int colCount = array[0].length;
            this.setData(array, colCount);
        }
    }

    public String getColumnName(int column) {
        StringBuffer result = new StringBuffer();
        while (column >= 0) {
            int colChar = (char)(column % 26) + 65;
            result.append(colChar);
            column = column / 26 - 1;
        }
        return result.toString();
    }

    public void setObject(int row, int column, LValue object) {
        super.setObject(row, column, (Object)object);
    }

    public LValue getValueAt(int row, int column) {
        return (LValue)this.getObject(row, column);
    }

    public void initialize(FormulaContext context) throws EvaluationException {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                LValue value = this.getValueAt(row, col);
                if (value == null) continue;
                value.initialize(context);
            }
        }
    }

    public TypeValuePair evaluate() throws EvaluationException {
        int colCount = -1;
        LValue[][] array = (LValue[][])this.getData();
        for (int i = 0; i < array.length; ++i) {
            LValue[] row = array[i];
            if (colCount > 0 && row.length != colCount) {
                throw new EvaluationException(LibFormulaErrorValue.ERROR_ILLEGAL_ARRAY_VALUE);
            }
            colCount = row.length;
        }
        return new TypeValuePair(DataTableType.TYPE, this);
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultDataTable table = (DefaultDataTable)super.clone();
        Object[][] data = this.getData();
        Object[][] targetData = (Object[][])data.clone();
        for (int i = 0; i < targetData.length; ++i) {
            Object[] objects = targetData[i];
            if (objects == null) continue;
            targetData[i] = (Object[])objects.clone();
            for (int j = 0; j < objects.length; ++j) {
                LValue object = (LValue)objects[j];
                if (object == null) continue;
                objects[j] = object.clone();
            }
        }
        table.setData(targetData, this.getColumnCount());
        return table;
    }

    public Type getValueType() {
        return DataTableType.TYPE;
    }

    public LValue[] getChildValues() {
        return new LValue[0];
    }

    public boolean isConstant() {
        if (this.constant == null) {
            this.constant = this.computeConstantValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.TRUE.equals(this.constant);
    }

    private boolean computeConstantValue() {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                LValue value = this.getValueAt(row, col);
                if (value.isConstant()) continue;
                return false;
            }
        }
        return true;
    }
}

