/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.lvalues;

import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.FunctionDescription;
import org.jfree.formula.function.FunctionRegistry;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.AbstractLValue;
import org.jfree.formula.lvalues.LValue;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.util.Log;

public class FormulaFunction
extends AbstractLValue {
    private String functionName;
    private LValue[] parameters;
    private Function function;
    private FunctionDescription metaData;

    public FormulaFunction(String functionName, LValue[] parameters) {
        this.functionName = functionName;
        this.parameters = parameters;
    }

    public void initialize(FormulaContext context) throws EvaluationException {
        super.initialize(context);
        FunctionRegistry registry = context.getFunctionRegistry();
        this.function = registry.createFunction(this.functionName);
        this.metaData = registry.getMetaData(this.functionName);
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i].initialize(context);
        }
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Function getFunction() {
        return this.function;
    }

    public FunctionDescription getMetaData() {
        return this.metaData;
    }

    public Object clone() throws CloneNotSupportedException {
        FormulaFunction fn = (FormulaFunction)super.clone();
        fn.parameters = (LValue[])this.parameters.clone();
        for (int i = 0; i < this.parameters.length; ++i) {
            LValue parameter = this.parameters[i];
            fn.parameters[i] = (LValue)parameter.clone();
        }
        return fn;
    }

    public TypeValuePair evaluate() throws EvaluationException {
        FormulaContext context = this.getContext();
        if (this.function == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_FUNCTION_VALUE);
        }
        try {
            return this.function.evaluate(context, new FormulaParameterCallback(this));
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
    }

    public LValue[] getChildValues() {
        return (LValue[])this.parameters.clone();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.functionName);
        b.append("(");
        for (int i = 0; i < this.parameters.length; ++i) {
            if (i > 0) {
                b.append(";");
            }
            LValue parameter = this.parameters[i];
            b.append(parameter);
        }
        b.append(")");
        return b.toString();
    }

    public boolean isConstant() {
        if (this.metaData.isVolatile()) {
            return false;
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            LValue value = this.parameters[i];
            if (value.isConstant()) continue;
            return false;
        }
        return true;
    }

    private static class FormulaParameterCallback
    implements ParameterCallback {
        private TypeValuePair[] backend;
        private FormulaFunction function;

        public FormulaParameterCallback(FormulaFunction function) {
            this.function = function;
            this.backend = new TypeValuePair[function.parameters.length];
        }

        private TypeValuePair get(int pos) throws EvaluationException {
            LValue parameter = this.function.parameters[pos];
            Type paramType = this.function.metaData.getParameterType(pos);
            if (parameter != null) {
                TypeValuePair result = parameter.evaluate();
                TypeRegistry typeRegistry = this.function.getContext().getTypeRegistry();
                TypeValuePair converted = typeRegistry.convertTo(paramType, result);
                if (converted == null) {
                    Log.debug((Object)("Failed to evaluate parameter " + pos + " on function " + this.function));
                    throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_AUTO_ARGUMENT_VALUE);
                }
                return converted;
            }
            return new TypeValuePair(paramType, this.function.metaData.getDefaultValue(pos));
        }

        public LValue getRaw(int position) {
            return this.function.parameters[position];
        }

        public Object getValue(int position) throws EvaluationException {
            TypeValuePair pair;
            TypeValuePair retval = this.backend[position];
            if (retval != null) {
                return retval.getValue();
            }
            this.backend[position] = pair = this.get(position);
            return pair.getValue();
        }

        public Type getType(int position) throws EvaluationException {
            TypeValuePair pair;
            TypeValuePair retval = this.backend[position];
            if (retval != null) {
                return retval.getType();
            }
            this.backend[position] = pair = this.get(position);
            return pair.getType();
        }

        public int getParameterCount() {
            return this.backend.length;
        }
    }
}

