/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.operators;

import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.operators.InfixOperator;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.formula.typing.TypeRegistryUtility;
import org.jfree.formula.typing.coretypes.NumberType;

public abstract class AbstractNumericOperator
implements InfixOperator {
    protected static final Number ZERO = new Integer(0);

    protected AbstractNumericOperator() {
    }

    public final TypeValuePair evaluate(FormulaContext context, TypeValuePair value1, TypeValuePair value2) throws EvaluationException {
        TypeRegistry typeRegistry = context.getTypeRegistry();
        if (value1 == null || value2 == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
        Object raw1 = value1.getValue();
        Object raw2 = value2.getValue();
        if (raw1 == null || raw2 == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        Number number1 = TypeRegistryUtility.convertToNumber(typeRegistry, value1.getType(), raw1, ZERO);
        Number number2 = TypeRegistryUtility.convertToNumber(typeRegistry, value2.getType(), raw2, ZERO);
        return new TypeValuePair(NumberType.GENERIC_NUMBER, this.evaluate(number1, number2));
    }

    protected abstract Number evaluate(Number var1, Number var2) throws EvaluationException;
}

