/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.operators;

import java.util.HashMap;
import java.util.Iterator;
import org.jfree.formula.operators.InfixOperator;
import org.jfree.formula.operators.OperatorFactory;
import org.jfree.formula.operators.PostfixOperator;
import org.jfree.formula.operators.PrefixOperator;
import org.jfree.util.Configuration;
import org.jfree.util.ObjectUtilities;

public class DefaultOperatorFactory
implements OperatorFactory {
    private static final String INFIX_PREFIX = "org.jfree.formula.operators.infix.";
    private static final String PREFIX_PREFIX = "org.jfree.formula.operators.prefix.";
    private static final String POSTFIX_PREFIX = "org.jfree.formula.operators.postfix.";
    private HashMap infixOperators = new HashMap();
    private HashMap prefixOperators = new HashMap();
    private HashMap postfixOperators = new HashMap();
    static /* synthetic */ Class class$org$jfree$formula$operators$DefaultOperatorFactory;
    static /* synthetic */ Class class$org$jfree$formula$operators$InfixOperator;
    static /* synthetic */ Class class$org$jfree$formula$operators$PrefixOperator;
    static /* synthetic */ Class class$org$jfree$formula$operators$PostfixOperator;

    public void initalize(Configuration configuration) {
        this.loadInfixOperators(configuration);
        this.loadPrefixOperators(configuration);
        this.loadPostfixOperators(configuration);
    }

    private void loadInfixOperators(Configuration configuration) {
        Iterator infixKeys = configuration.findPropertyKeys(INFIX_PREFIX);
        while (infixKeys.hasNext()) {
            String tokenKey;
            String token;
            String operatorClass;
            String configKey = (String)infixKeys.next();
            if (!configKey.endsWith(".class") || (operatorClass = configuration.getConfigProperty(configKey)) == null || operatorClass.length() == 0 || (token = configuration.getConfigProperty(tokenKey = configKey.substring(0, configKey.length() - ".class".length()) + ".token")) == null) continue;
            String tokenTrimmed = token.trim();
            Object operator = ObjectUtilities.loadAndInstantiate((String)operatorClass, (Class)(class$org$jfree$formula$operators$DefaultOperatorFactory == null ? DefaultOperatorFactory.class$("org.jfree.formula.operators.DefaultOperatorFactory") : class$org$jfree$formula$operators$DefaultOperatorFactory), (Class)(class$org$jfree$formula$operators$InfixOperator == null ? DefaultOperatorFactory.class$("org.jfree.formula.operators.InfixOperator") : class$org$jfree$formula$operators$InfixOperator));
            if (!(operator instanceof InfixOperator)) continue;
            this.infixOperators.put(tokenTrimmed, operator);
        }
    }

    private void loadPrefixOperators(Configuration configuration) {
        Iterator infixKeys = configuration.findPropertyKeys(PREFIX_PREFIX);
        int infixLength = PREFIX_PREFIX.length();
        while (infixKeys.hasNext()) {
            String tokenKey;
            String token;
            String operatorClass;
            String configKey = (String)infixKeys.next();
            if (!configKey.endsWith(".class") || (operatorClass = configuration.getConfigProperty(configKey)) == null || operatorClass.length() == 0 || (token = configuration.getConfigProperty(tokenKey = configKey.substring(0, configKey.length() - ".class".length()) + ".token")) == null) continue;
            String tokenTrimmed = token.trim();
            Object operator = ObjectUtilities.loadAndInstantiate((String)operatorClass, (Class)(class$org$jfree$formula$operators$DefaultOperatorFactory == null ? DefaultOperatorFactory.class$("org.jfree.formula.operators.DefaultOperatorFactory") : class$org$jfree$formula$operators$DefaultOperatorFactory), (Class)(class$org$jfree$formula$operators$PrefixOperator == null ? DefaultOperatorFactory.class$("org.jfree.formula.operators.PrefixOperator") : class$org$jfree$formula$operators$PrefixOperator));
            if (!(operator instanceof PrefixOperator)) continue;
            this.prefixOperators.put(tokenTrimmed, operator);
        }
    }

    private void loadPostfixOperators(Configuration configuration) {
        Iterator infixKeys = configuration.findPropertyKeys(POSTFIX_PREFIX);
        int infixLength = POSTFIX_PREFIX.length();
        while (infixKeys.hasNext()) {
            String tokenKey;
            String token;
            String operatorClass;
            String configKey = (String)infixKeys.next();
            if (!configKey.endsWith(".class") || (operatorClass = configuration.getConfigProperty(configKey)) == null || operatorClass.length() == 0 || (token = configuration.getConfigProperty(tokenKey = configKey.substring(0, configKey.length() - ".class".length()) + ".token")) == null) continue;
            String tokenTrimmed = token.trim();
            Object operator = ObjectUtilities.loadAndInstantiate((String)operatorClass, (Class)(class$org$jfree$formula$operators$DefaultOperatorFactory == null ? DefaultOperatorFactory.class$("org.jfree.formula.operators.DefaultOperatorFactory") : class$org$jfree$formula$operators$DefaultOperatorFactory), (Class)(class$org$jfree$formula$operators$PostfixOperator == null ? DefaultOperatorFactory.class$("org.jfree.formula.operators.PostfixOperator") : class$org$jfree$formula$operators$PostfixOperator));
            if (!(operator instanceof PostfixOperator)) continue;
            this.postfixOperators.put(tokenTrimmed, operator);
        }
    }

    public InfixOperator createInfixOperator(String operator) {
        return (InfixOperator)this.infixOperators.get(operator);
    }

    public PostfixOperator createPostfixOperator(String operator) {
        return (PostfixOperator)this.postfixOperators.get(operator);
    }

    public PrefixOperator createPrefixOperator(String operator) {
        return (PrefixOperator)this.prefixOperators.get(operator);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

