/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.operators;

import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.operators.InfixOperator;
import org.jfree.formula.typing.ExtendedComparator;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.formula.typing.coretypes.LogicalType;

public class EqualOperator
implements InfixOperator {
    private static final TypeValuePair RETURN_TRUE = new TypeValuePair(LogicalType.TYPE, Boolean.TRUE);
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);

    public TypeValuePair evaluate(FormulaContext context, TypeValuePair value1, TypeValuePair value2) throws EvaluationException {
        Type type2;
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Object value1Raw = value1.getValue();
        Object value2Raw = value2.getValue();
        if (value1Raw == null || value2Raw == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        Type type1 = value1.getType();
        ExtendedComparator comparator = typeRegistry.getComparator(type1, type2 = value2.getType());
        boolean result = comparator.isEqual(type1, value1Raw, type2, value2Raw);
        if (result) {
            return RETURN_TRUE;
        }
        return RETURN_FALSE;
    }

    public int getLevel() {
        return 400;
    }

    public String toString() {
        return "=";
    }

    public boolean isLeftOperation() {
        return true;
    }

    public boolean isAssociative() {
        return false;
    }
}

