/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.operators;

import java.math.BigDecimal;
import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.operators.PrefixOperator;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.TypeRegistry;

public class MinusSignOperator
implements PrefixOperator {
    private static final BigDecimal ZERO = new BigDecimal(0);

    public TypeValuePair evaluate(FormulaContext context, TypeValuePair value1) throws EvaluationException {
        Type type = value1.getType();
        Object val = value1.getValue();
        if (val == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        if (type.isFlagSet("type.numeric")) {
            TypeRegistry typeRegistry = context.getTypeRegistry();
            Number number = typeRegistry.convertToNumber(type, val);
            BigDecimal value = this.getAsBigDecimal(number);
            return new TypeValuePair(type, ZERO.subtract(value));
        }
        if (val instanceof Number) {
            BigDecimal value = this.getAsBigDecimal((Number)val);
            return new TypeValuePair(type, ZERO.subtract(value));
        }
        throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
    }

    private BigDecimal getAsBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        return new BigDecimal(number.toString());
    }

    public String toString() {
        return "-";
    }
}

