/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.operators;

import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.operators.InfixOperator;
import org.jfree.formula.typing.ExtendedComparator;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.formula.typing.coretypes.LogicalType;

public class NotEqualOperator
implements InfixOperator {
    private static final TypeValuePair RETURN_TRUE = new TypeValuePair(LogicalType.TYPE, Boolean.TRUE);
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);

    public TypeValuePair evaluate(FormulaContext context, TypeValuePair value1, TypeValuePair value2) throws EvaluationException {
        TypeRegistry typeRegistry = context.getTypeRegistry();
        ExtendedComparator comparator = typeRegistry.getComparator(value1.getType(), value2.getType());
        boolean result = comparator.isEqual(value1.getType(), value1.getValue(), value2.getType(), value2.getValue());
        if (!result) {
            return RETURN_TRUE;
        }
        return RETURN_FALSE;
    }

    public int getLevel() {
        return 400;
    }

    public String toString() {
        return "<>";
    }

    public boolean isLeftOperation() {
        return true;
    }

    public boolean isAssociative() {
        return false;
    }
}

