/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.operators;

import java.math.BigDecimal;
import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.operators.OperatorUtility;
import org.jfree.formula.operators.PostfixOperator;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.TypeRegistry;

public class PercentageOperator
implements PostfixOperator {
    private static final BigDecimal HUNDRED = new BigDecimal(100);

    public TypeValuePair evaluate(FormulaContext context, TypeValuePair value1) throws EvaluationException {
        Object rawValue = value1.getValue();
        if (rawValue == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        Type type = value1.getType();
        TypeRegistry typeRegistry = context.getTypeRegistry();
        if (!type.isFlagSet("type.numeric") && !type.isFlagSet("type.any")) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        Number number = typeRegistry.convertToNumber(type, rawValue);
        BigDecimal value = OperatorUtility.getAsBigDecimal(number);
        BigDecimal divide = value.divide(HUNDRED, value.scale() + 2, 4);
        return new TypeValuePair(type, divide);
    }

    public String toString() {
        return "%";
    }
}

