/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.util;

import java.math.BigDecimal;
import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jfree.formula.DefaultLocalizationContext;
import org.jfree.formula.LocalizationContext;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.coretypes.DateTimeType;
import org.jfree.formula.util.HSSFDateUtil;

public class DateUtil {
    private static final Date ISO8001_TIME = new GregorianCalendar().getTime();

    public static Date normalizeDate(Date fromDate, Type toType) {
        return DateUtil.normalizeDate(fromDate, toType, true);
    }

    public static Date normalizeDate(Date fromDate, Type toType, boolean convertSerial) {
        if (fromDate == null || toType == null) {
            throw new IllegalArgumentException();
        }
        if (convertSerial) {
            Number serial = DateUtil.toSerialDate(fromDate, null);
            serial = DateUtil.normalizeDate(serial, toType);
            fromDate = DateUtil.toJavaDate(serial, null);
        }
        if (toType.isFlagSet("type.time")) {
            return new Time(fromDate.getTime());
        }
        if (toType.isFlagSet("type.date")) {
            return new java.sql.Date(fromDate.getTime());
        }
        if (toType.isFlagSet("type.datetime")) {
            return new Date(fromDate.getTime());
        }
        return fromDate;
    }

    public static Number normalizeDate(Number fromSerialDate, Type toType) {
        if (fromSerialDate == null || toType == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal o = new BigDecimal(fromSerialDate.doubleValue()).setScale(5, 0);
        if (toType.isFlagSet("type.time")) {
            return o.subtract(new BigDecimal(o.intValue()));
        }
        if (toType.isFlagSet("type.date")) {
            return new Integer(fromSerialDate.intValue());
        }
        return o;
    }

    public static Date toJavaDate(Number serialDate, LocalizationContext context) {
        Date javaDate = HSSFDateUtil.getJavaDate(serialDate.doubleValue());
        long l = javaDate.getTime() / 1000L * 1000L;
        return new Date(l);
    }

    public static Number toSerialDate(Date date, LocalizationContext context) {
        double serial = HSSFDateUtil.getExcelDate(date);
        return new Double(serial);
    }

    public static void main(String[] args) {
        DefaultLocalizationContext context = new DefaultLocalizationContext();
        java.sql.Date createDate = DateUtil.createDate(2006, 5, 1, context);
        Number serial = DateUtil.toSerialDate(createDate, context);
        System.out.println(createDate);
        System.out.println(serial);
        Date toJavaDate = DateUtil.toJavaDate(serial, context);
        System.out.println(DateUtil.normalizeDate(toJavaDate, (Type)DateTimeType.DATE_TYPE));
        System.out.println(toJavaDate);
        System.out.println(HSSFDateUtil.getJavaDate(serial.doubleValue()));
    }

    public static Date now(LocalizationContext context) {
        GregorianCalendar gc = new GregorianCalendar(context.getTimeZone(), context.getLocale());
        gc.set(14, 0);
        return gc.getTime();
    }

    public static Date createDateTime(int year, int month, int day, int hour, int minute, int second, LocalizationContext context) {
        GregorianCalendar gc = new GregorianCalendar(context.getTimeZone(), context.getLocale());
        gc.set(5, day);
        gc.set(2, month);
        gc.set(1, year);
        gc.set(14, 0);
        gc.set(11, hour);
        gc.set(12, minute);
        gc.set(13, second);
        return gc.getTime();
    }

    public static Time createTime(int hour, int minute, int second, LocalizationContext context) {
        GregorianCalendar gc = new GregorianCalendar(context.getTimeZone(), context.getLocale());
        gc.setTime(ISO8001_TIME);
        gc.set(14, 0);
        gc.set(11, hour);
        gc.set(12, minute);
        gc.set(13, second);
        return new Time(gc.getTime().getTime());
    }

    public static java.sql.Date createDate(int year, int month, int day, LocalizationContext context) {
        GregorianCalendar gc = new GregorianCalendar(context.getTimeZone(), context.getLocale());
        gc.set(5, day);
        gc.set(2, month - 1);
        gc.set(1, year);
        gc.set(14, 0);
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        return new java.sql.Date(gc.getTime().getTime());
    }

    public static Calendar createCalendar(Date date, LocalizationContext context) {
        GregorianCalendar gc = new GregorianCalendar(context.getTimeZone(), context.getLocale());
        gc.setTime(date);
        return gc;
    }
}

