/*
 * Decompiled with CFR 0.152.
 */
package complexlib;

import complexlib.ComplexTestCase;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MethodThread
extends Thread {
    private Method mTestMethod = null;
    private Object mInvokeClass = null;
    private PrintWriter mLog = null;
    private String mErrMessage = null;
    private boolean mExceptionHappened = false;

    public MethodThread(Method method, Object object, PrintWriter printWriter) {
        this.mTestMethod = method;
        this.mInvokeClass = object;
        this.mLog = printWriter;
    }

    public void run() {
        block4: {
            try {
                this.mTestMethod.invoke(this.mInvokeClass, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace(this.mLog);
                this.mErrMessage = illegalAccessException.getMessage();
                this.mExceptionHappened = true;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ComplexTestCase.AssureException) break block4;
                throwable.printStackTrace(this.mLog);
                this.mErrMessage = throwable.getMessage();
                if (this.mErrMessage == null) {
                    this.mErrMessage = throwable.toString();
                }
                this.mExceptionHappened = true;
            }
        }
    }

    public String getErrorMessage() {
        return this.mErrMessage;
    }

    public boolean hasErrorMessage() {
        return this.mExceptionHappened;
    }

    public void destroy() {
        try {
            this.interrupt();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace(this.mLog);
            this.mErrMessage = securityException.getMessage();
            this.mExceptionHappened = true;
        }
    }
}

