/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.DBHelper;
import convwatch.GlobalLogWriter;
import convwatch.OSHelper;
import convwatch.ShareConnection;
import java.sql.Connection;
import java.util.StringTokenizer;

public class DB
extends DBHelper {
    private static String m_sReferenceVersion;
    private static String m_sCurrentVersion;
    private static String m_sDocumentPool;
    private static String m_sEnvironment;

    public static void startFile(String string, String string2) {
        if (string == null) {
            return;
        }
        DB.fillVariables(string);
        DB.updatestate_currentdocs(string2, "started");
    }

    public static void ref_finishedFile(String string, String string2) {
        if (string == null) {
            return;
        }
        DB.fillVariables(string);
        DB.updatestate_currentdocs(string2, "ref-finished");
    }

    public static void ref_failedFile(String string, String string2) {
        if (string == null) {
            return;
        }
        DB.fillVariables(string);
        DB.updatestate_currentdocs(string2, "ref-failed");
    }

    public static void finishedFile(String string, String string2) {
        if (string == null) {
            return;
        }
        DB.fillVariables(string);
        DB.updatestate_currentdocs(string2, "PASSED-OK");
    }

    public static void failedFile(String string, String string2) {
        if (string == null) {
            return;
        }
        DB.fillVariables(string);
        DB.updatestate_currentdocs(string2, "PASSED-FAILED");
    }

    public static void reallyfailedFile(String string, String string2) {
        if (string == null) {
            return;
        }
        DB.fillVariables(string);
        DB.updatestate_currentdocs(string2, "FAILED-FAILED");
    }

    public static void writeToDB(String string, String string2, String string3, String string4, String string5, String string6, int n) {
        if (string == null) {
            return;
        }
        DB.fillVariables(string);
    }

    private static String getEnvironment() {
        if (OSHelper.isWindows()) {
            return "wntmsci";
        }
        if (OSHelper.isSolarisIntel()) {
            return "unxsoli";
        }
        if (OSHelper.isSolarisSparc()) {
            return "unxsols";
        }
        if (OSHelper.isLinuxIntel()) {
            return "unxlngi";
        }
        GlobalLogWriter.get().println("Unknown environment.");
        GlobalLogWriter.get().println("os.name := " + System.getProperty("os.name").toLowerCase());
        GlobalLogWriter.get().println("os.arch := " + System.getProperty("os.arch"));
        return "";
    }

    private static void fillVariables(String string) {
        m_sEnvironment = DB.getEnvironment();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("p:")) {
                m_sReferenceVersion = string2.substring(2);
                GlobalLogWriter.get().println("Found previous version: " + m_sReferenceVersion);
                continue;
            }
            if (string2.startsWith("c:")) {
                m_sCurrentVersion = string2.substring(2);
                GlobalLogWriter.get().println("Found current version: " + m_sCurrentVersion);
                continue;
            }
            if (!string2.startsWith("d:")) continue;
            m_sDocumentPool = string2.substring(2);
            GlobalLogWriter.get().println("Found documentpool version: " + m_sDocumentPool);
        }
    }

    public static void insertinto_file(String string, String string2, String string3, String string4, String string5, int n) {
        new ShareConnection();
        Connection connection = ShareConnection.getConnection();
        String string6 = string.replace('\\', '/');
        String string7 = "DELETE FROM file WHERE filename = " + DB.Quote(string6);
        DB.ExecSQL(connection, string7);
        String string8 = "type, filename, basename, fileformat, buildid, resolution, date";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DB.Quote(string5)).append(",").append(DB.Quote(string6)).append(",").append(DB.Quote(string2)).append(",").append(DB.Quote(string3)).append(",").append(DB.Quote(string4)).append(",").append(n).append(",").append(DB.Quote(DB.today()));
        DB.SQLinsertValues(connection, "file", string8, stringBuffer.toString());
    }

    public static void updatestate_currentdocs(String string, String string2) {
        new ShareConnection();
        Connection connection = ShareConnection.getConnection();
        String string3 = string.replace('\\', '/');
        String string4 = "state=" + DB.Quote(string2);
        String string5 = DB.getWhere() + " AND " + "name=" + DB.Quote(string3);
        DB.SQLupdateValue(connection, "currentdocs", string4, string5);
    }

    public static String getWhere() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("environment").append("=").append(DB.Quote(m_sEnvironment)).append(" AND ").append("referenceversion").append("=").append(DB.Quote(m_sReferenceVersion)).append(" AND ").append("currentversion").append("=").append(DB.Quote(m_sCurrentVersion)).append(" AND ").append("documentpool").append("=").append(DB.Quote(m_sDocumentPool));
        return stringBuffer.toString();
    }

    public static void filesRemove(String string) {
        if (string == null) {
            return;
        }
        DB.fillVariables(string);
        new ShareConnection();
        Connection connection = ShareConnection.getConnection();
        String string2 = "DELETE FROM currentdocs WHERE " + DB.getWhere();
        DB.ExecSQL(connection, string2);
    }

    public static void fileInsert(String string, String string2, String string3) {
        if (string == null) {
            return;
        }
        DB.fillVariables(string);
        String string4 = string2.replace('\\', '/');
        new ShareConnection();
        Connection connection = ShareConnection.getConnection();
        String string5 = "environment, referenceversion, currentversion, documentpool, name, state";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DB.Quote(m_sEnvironment)).append(",").append(DB.Quote(m_sReferenceVersion)).append(",").append(DB.Quote(m_sCurrentVersion)).append(",").append(DB.Quote(m_sDocumentPool)).append(",").append(DB.Quote(string4)).append(",").append(DB.Quote("undone"));
        DB.SQLinsertValues(connection, "currentdocs", string5, stringBuffer.toString());
    }

    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        String string3 = "";
        DB.fillVariables("p:m128,c:m134,d:demo");
    }
}

