/*
 * Decompiled with CFR 0.152.
 */
package ifc.document;

import com.sun.star.beans.PropertyValue;
import com.sun.star.document.XExporter;
import com.sun.star.document.XFilter;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XFilter
extends MultiMethodTest {
    public XFilter oObj = null;
    protected PropertyValue[] mDesc = null;
    protected FilterChecker checker = null;
    protected XComponent sourceDoc = null;
    protected boolean dummy = false;

    public void before() {
        String string = this.tEnv.getTestCase().getObjectName();
        if (string.indexOf("Importer") > 0) {
            this.log.println(string + " contains only a dummy implementation");
            this.log.println("therefore all methods are skipped");
            this.dummy = true;
        }
        this.mDesc = (PropertyValue[])this.tEnv.getObjRelation("MediaDescriptor");
        this.checker = (FilterChecker)this.tEnv.getObjRelation("XFilter.Checker");
        if (this.mDesc == null && !this.dummy) {
            throw new StatusException(Status.failed("Relation not found."));
        }
        this.sourceDoc = (XComponent)this.tEnv.getObjRelation("SourceDocument");
        try {
            if (this.sourceDoc != null) {
                XExporter xExporter = (XExporter)UnoRuntime.queryInterface(XExporter.class, (Object)this.oObj);
                xExporter.setSourceDocument(this.sourceDoc);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void after() {
        if (this.dummy) {
            throw new StatusException(Status.skipped(true));
        }
    }

    public void _filter() {
        if (this.dummy) {
            this.tRes.tested("filter()", true);
            return;
        }
        boolean bl = true;
        bl = this.oObj.filter(this.mDesc);
        if (this.checker == null) {
            this.log.println("!!! Warning : cann't check filter as no relation found");
        } else {
            bl &= this.checker.checkFilter();
        }
        this.tRes.tested("filter()", bl);
    }

    public void _cancel() {
        if (this.dummy) {
            this.tRes.tested("cancel()", true);
            return;
        }
        this.requiredMethod("filter()");
        if (this.tEnv.getObjRelation("NoFilter.cancel()") != null) {
            System.out.println("Cancel not tested.");
            this.log.println("Method 'cancel()' is not working and therefore not tested.\nResult is set to SKIPPED.OK");
            this.tRes.tested("cancel()", Status.skipped(true));
            return;
        }
        boolean bl = false;
        FilterThread filterThread = new FilterThread(this.oObj);
        filterThread.mdesc = this.mDesc;
        filterThread.start();
        this.oObj.cancel();
        while (filterThread.isAlive()) {
        }
        bl = !filterThread.filterRes;
        this.tRes.tested("cancel()", bl);
    }

    protected class FilterThread
    extends Thread {
        public boolean filterRes = true;
        private XFilter Filter = null;
        public PropertyValue[] mdesc = null;

        public FilterThread(XFilter xFilter) {
            this.Filter = xFilter;
        }

        public void run() {
            this.filterRes = this.Filter.filter(this.mdesc);
        }
    }

    public static interface FilterChecker {
        public boolean checkFilter();
    }
}

