/*
 * Decompiled with CFR 0.152.
 */
package ifc.i18n;

import com.sun.star.i18n.CalendarItem;
import com.sun.star.i18n.XCalendar;
import com.sun.star.i18n.XLocaleData;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;

public class _XCalendar
extends MultiMethodTest {
    private boolean debug = false;
    public XCalendar oObj = null;
    public String[][] calendars;
    public int[] count;
    public double newDTime = 1000.75;
    public short newValue = (short)2;
    public short firstDay = (short)2;
    public short mdfw = (short)3;
    double aOriginalDTime = 0.0;
    Locale[] installed_locales;

    public void before() {
        XLocaleData xLocaleData = null;
        try {
            xLocaleData = (XLocaleData)UnoRuntime.queryInterface(XLocaleData.class, ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.i18n.LocaleData"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.installed_locales = xLocaleData.getAllInstalledLocaleNames();
        this.calendars = new String[this.installed_locales.length][];
        this.count = new int[this.installed_locales.length];
        this.oObj.loadDefaultCalendar(this.installed_locales[0]);
        this.aOriginalDTime = this.oObj.getDateTime();
        this.debug = this.tParam.getBool("DebugIsActive");
    }

    public void after() {
        this.oObj.loadDefaultCalendar(this.installed_locales[0]);
        this.oObj.setDateTime(this.aOriginalDTime);
    }

    public void _loadDefaultCalendar() {
        boolean bl = true;
        for (int i = 0; i < this.installed_locales.length; ++i) {
            String string = "Language: " + this.installed_locales[i].Language + ", Country: " + this.installed_locales[i].Country + ", Variant: " + this.installed_locales[i].Country;
            this.oObj.loadDefaultCalendar(this.installed_locales[i]);
            if (!this.oObj.getLoadedCalendar().Default) {
                this.log.println(string + " ... FAILED");
            }
            bl &= this.oObj.getLoadedCalendar().Default;
        }
        this.tRes.tested("loadDefaultCalendar()", bl);
    }

    public void _getAllCalendars() {
        boolean bl = true;
        for (int i = 0; i < this.installed_locales.length; ++i) {
            String string = "Language: " + this.installed_locales[i].Language + ", Country: " + this.installed_locales[i].Country + ", Variant: " + this.installed_locales[i].Country;
            this.calendars[i] = this.oObj.getAllCalendars(this.installed_locales[i]);
            this.count[i] = this.calendars[i].length - 1;
            if (this.calendars[i].length <= 0) {
                this.log.println(string + " ... FAILED");
            }
            bl &= this.calendars[i].length > 0;
        }
        this.tRes.tested("getAllCalendars()", bl);
    }

    public void _loadCalendar() {
        boolean bl = true;
        this.requiredMethod("getAllCalendars()");
        for (int i = 0; i < this.installed_locales.length; ++i) {
            String string = "Language: " + this.installed_locales[i].Language + ", Country: " + this.installed_locales[i].Country + ", Variant: " + this.installed_locales[i].Country;
            this.oObj.loadCalendar(this.calendars[i][0], this.installed_locales[i]);
            if (!this.calendars[i][0].equals(this.oObj.getLoadedCalendar().Name)) {
                this.log.println(string + " ... FAILED");
            }
            bl &= this.calendars[i][0].equals(this.oObj.getLoadedCalendar().Name);
        }
        this.tRes.tested("loadCalendar()", bl);
    }

    public void _getLoadedCalendar() {
        boolean bl = true;
        this.requiredMethod("loadCalendar()");
        for (int i = 0; i < this.installed_locales.length; ++i) {
            String string = "Language: " + this.installed_locales[i].Language + ", Country: " + this.installed_locales[i].Country + ", Variant: " + this.installed_locales[i].Country;
            this.oObj.loadCalendar(this.calendars[i][0], this.installed_locales[i]);
            if (!this.calendars[i][0].equals(this.oObj.getLoadedCalendar().Name)) {
                this.log.println(string + " ... FAILED");
            }
            bl &= this.calendars[i][0].equals(this.oObj.getLoadedCalendar().Name);
        }
        this.tRes.tested("getLoadedCalendar()", bl);
    }

    public void _getUniqueID() {
        boolean bl = true;
        for (int i = 0; i < this.installed_locales.length; ++i) {
            String string = "Language: " + this.installed_locales[i].Language + ", Country: " + this.installed_locales[i].Country + ", Variant: " + this.installed_locales[i].Country;
            this.oObj.loadCalendar(this.calendars[i][0], this.installed_locales[i]);
            String string2 = this.oObj.getUniqueID();
            if (!string2.equals(this.calendars[i][0])) {
                this.log.println(string + " ... FAILED");
            }
            bl &= string2.equals(this.calendars[i][0]);
        }
        this.tRes.tested("getUniqueID()", bl);
    }

    public void _setDateTime() {
        boolean bl = true;
        for (int i = 0; i < this.installed_locales.length; ++i) {
            String string = "Language: " + this.installed_locales[i].Language + ", Country: " + this.installed_locales[i].Country + ", Variant: " + this.installed_locales[i].Country;
            this.oObj.setDateTime(this.newDTime);
            double d = this.oObj.getDateTime();
            if (d != this.newDTime) {
                this.log.println(string + " ... FAILED");
            }
            bl &= d == this.newDTime;
        }
        this.tRes.tested("setDateTime()", bl);
    }

    public void _getDateTime() {
        boolean bl = true;
        for (int i = 0; i < this.installed_locales.length; ++i) {
            String string = "Language: " + this.installed_locales[i].Language + ", Country: " + this.installed_locales[i].Country + ", Variant: " + this.installed_locales[i].Country;
            this.oObj.setDateTime(this.newDTime);
            double d = this.oObj.getDateTime();
            if (d != this.newDTime) {
                this.log.println(string + " ... FAILED");
            }
            bl &= d == this.newDTime;
        }
        this.tRes.tested("getDateTime()", bl);
    }

    public void _setValue() {
        boolean bl = true;
        for (int i = 0; i < this.installed_locales.length; ++i) {
            String string = "";
            String string2 = "Language: " + this.installed_locales[i].Language + ", Country: " + this.installed_locales[i].Country + ", Variant: " + this.installed_locales[i].Variant + ", Name: " + this.calendars[i][this.count[i]];
            String[] stringArray = new String[]{"DAY_OF_MONTH", "HOUR", "MINUTE", "SECOND", "MILLISECOND", "YEAR", "MONTH"};
            this.oObj.loadCalendar(this.calendars[i][this.count[i]], this.installed_locales[i]);
            short[] sArray = new short[]{1, 5, 6, 7, 8, 11, 12};
            for (int j = 0; j < sArray.length; ++j) {
                int n;
                short s;
                this.oObj.setDateTime(0.0);
                short[] sArray2 = new short[sArray.length];
                for (s = 0; s < sArray2.length; ++s) {
                    sArray2[s] = this.oObj.getValue(sArray[s]);
                }
                s = this.oObj.getValue(sArray[j]);
                if (sArray[j] == 12) {
                    s = this.newValue;
                }
                this.oObj.setValue(sArray[j], s);
                short s2 = this.oObj.getValue(sArray[j]);
                if (s2 == s) continue;
                if (this.debug) {
                    this.log.println("ERROR occure: tried to set " + stringArray[j] + " to value " + s);
                }
                this.log.println("list of values BEFORE set " + stringArray[j] + " to value " + s + ":");
                for (n = 0; n < sArray2.length; ++n) {
                    this.log.println(stringArray[n] + ":" + sArray2[n]);
                }
                this.log.println("list of values AFTER set " + stringArray[j] + " to value " + s + ":");
                for (n = 0; n < sArray.length; ++n) {
                    this.log.println(stringArray[n] + ":" + this.oObj.getValue(sArray[n]));
                }
                string = string + "failed for " + stringArray[j] + " expected " + s + " gained " + s2 + " ; \n";
            }
            if (string.equals("")) {
                this.log.println(string2 + " ... OK");
            } else {
                this.log.println("*** " + string2 + " ... FAILED ***");
                this.log.println(string);
            }
            bl &= string.equals("");
        }
        this.tRes.tested("setValue()", bl);
    }

    public void _getValue() {
        boolean bl = true;
        this.requiredMethod("setValue()");
        short s = this.oObj.getValue((short)12);
        if (!(bl &= s == this.newValue)) {
            this.log.println("the returned value is not the expected value:");
            this.log.println("expexted: " + this.newValue + "  returned value: " + s);
        }
        this.tRes.tested("getValue()", bl);
    }

    public void _addValue() {
        boolean bl = true;
        this.requiredMethod("getValue()");
        this.oObj.addValue((short)12, 1);
        short s = this.oObj.getValue((short)12);
        if (!(bl &= s > this.newValue)) {
            this.log.println("the returned value is not the expected value:");
            this.log.println("expexted: " + this.newValue + "  returned value: " + s);
        }
        this.tRes.tested("addValue()", bl);
    }

    public void _setFirstDayOfWeek() {
        boolean bl = true;
        this.oObj.setFirstDayOfWeek(this.firstDay);
        this.tRes.tested("setFirstDayOfWeek()", bl &= true);
    }

    public void _getFirstDayOfWeek() {
        boolean bl = true;
        this.requiredMethod("setFirstDayOfWeek()");
        short s = this.oObj.getFirstDayOfWeek();
        this.tRes.tested("getFirstDayOfWeek()", bl &= s == this.firstDay);
    }

    public void _setMinimumNumberOfDaysForFirstWeek() {
        boolean bl = true;
        this.oObj.setMinimumNumberOfDaysForFirstWeek(this.mdfw);
        this.tRes.tested("setMinimumNumberOfDaysForFirstWeek()", bl &= true);
    }

    public void _getMinimumNumberOfDaysForFirstWeek() {
        boolean bl = true;
        this.requiredMethod("setMinimumNumberOfDaysForFirstWeek()");
        short s = this.oObj.getMinimumNumberOfDaysForFirstWeek();
        this.tRes.tested("getMinimumNumberOfDaysForFirstWeek()", bl &= s == this.mdfw);
    }

    public void _getNumberOfMonthsInYear() {
        boolean bl = true;
        short s = this.oObj.getNumberOfMonthsInYear();
        this.tRes.tested("getNumberOfMonthsInYear()", bl &= s == 12);
    }

    public void _getNumberOfDaysInWeek() {
        boolean bl = true;
        short s = this.oObj.getNumberOfDaysInWeek();
        this.tRes.tested("getNumberOfDaysInWeek()", bl &= s == 7);
    }

    public void _getMonths() {
        boolean bl = true;
        CalendarItem[] calendarItemArray = this.oObj.getMonths();
        this.tRes.tested("getMonths()", bl &= calendarItemArray.length == 12);
    }

    public void _getDays() {
        boolean bl = true;
        CalendarItem[] calendarItemArray = this.oObj.getDays();
        this.tRes.tested("getDays()", bl &= calendarItemArray.length == 7);
    }

    public void _getDisplayName() {
        boolean bl = true;
        this.oObj.loadCalendar(this.calendars[0][0], this.installed_locales[0]);
        String string = this.oObj.getDisplayName((short)2, this.newValue, (short)0);
        this.tRes.tested("getDisplayName()", bl &= string.length() == 3);
    }

    public void _isValid() {
        boolean bl = true;
        this.oObj.loadDefaultCalendar(this.installed_locales[0]);
        this.oObj.setValue((short)12, (short)37);
        bl &= !this.oObj.isValid();
        this.oObj.setValue((short)12, (short)10);
        this.tRes.tested("isValid()", bl &= this.oObj.isValid());
    }
}

