/*
 * Decompiled with CFR 0.152.
 */
package ifc.i18n;

import com.sun.star.i18n.XCollator;
import com.sun.star.lang.Locale;
import java.text.Collator;
import lib.MultiMethodTest;

public class _XCollator
extends MultiMethodTest {
    public XCollator oObj = null;
    private String[] alg = null;
    private int[] opt = null;
    Locale loc = new Locale("en", "EN", "");

    public void _listCollatorAlgorithms() {
        this.alg = this.oObj.listCollatorAlgorithms(this.loc);
        this.log.println("Collator algorithms :");
        if (this.alg != null) {
            for (int i = 0; i < this.alg.length; ++i) {
                this.log.println("  '" + this.alg[i] + "'");
            }
            this.tRes.tested("listCollatorAlgorithms()", this.alg.length > 0);
        } else {
            this.tRes.tested("listCollatorAlgorithms()", false);
        }
    }

    public void _listCollatorOptions() {
        this.requiredMethod("listCollatorAlgorithms()");
        this.opt = this.oObj.listCollatorOptions(this.alg[0]);
        this.log.println("Collator '" + this.alg[0] + "' options :");
        if (this.opt != null) {
            for (int i = 0; i < this.opt.length; ++i) {
                this.log.println("  " + this.opt[i]);
            }
            this.tRes.tested("listCollatorOptions()", true);
        } else {
            this.tRes.tested("listCollatorOptions()", false);
        }
    }

    public void _loadDefaultCollator() {
        this.oObj.loadDefaultCollator(this.loc, 0);
        boolean bl = this.oObj.compareString("A", "a") != 0;
        this.oObj.loadDefaultCollator(this.loc, 1);
        this.tRes.tested("loadDefaultCollator()", bl &= this.oObj.compareString("a", "A") == 0);
    }

    public void _loadCollatorAlgorithm() {
        this.requiredMethod("listCollatorAlgorithms()");
        this.oObj.loadCollatorAlgorithm(this.alg[0], this.loc, 1);
        boolean bl = this.oObj.compareString("A", "a") == 0;
        this.oObj.loadCollatorAlgorithm(this.alg[0], this.loc, 0);
        this.tRes.tested("loadCollatorAlgorithm()", bl &= this.oObj.compareString("a", "A") != 0);
    }

    public void _loadCollatorAlgorithmWithEndUserOption() {
        this.requiredMethod("listCollatorAlgorithms()");
        this.oObj.loadCollatorAlgorithmWithEndUserOption(this.alg[0], this.loc, new int[]{0});
        boolean bl = this.oObj.compareString("A", "a") != 0;
        this.oObj.loadCollatorAlgorithmWithEndUserOption(this.alg[0], this.loc, new int[]{1});
        bl = this.oObj.compareString("A", "a") == 0;
        this.tRes.tested("loadCollatorAlgorithmWithEndUserOption()", bl);
    }

    public void _compareSubstring() {
        int n;
        boolean bl = true;
        char[] cArray = new char[2];
        Collator collator = null;
        this.log.println(" #### Testing English locale ####");
        this.oObj.loadDefaultCollator(this.loc, 0);
        collator = Collator.getInstance(new java.util.Locale("en", "EN"));
        for (n = 32; n < 127; n = (int)((char)(n + 1))) {
            cArray[0] = n;
            cArray[1] = (char)(n + 1);
            bl &= this.testCompareSubstring(cArray, collator);
        }
        this.log.println(" #### Testing Russian locale ####");
        this.oObj.loadDefaultCollator(new Locale("ru", "RU", ""), 0);
        collator = Collator.getInstance(new java.util.Locale("ru", "RU"));
        for (n = 1040; n < 1104; n = (int)((char)(n + 1))) {
            cArray[0] = n;
            cArray[1] = (char)(n + 1);
            bl &= this.testCompareSubstring(cArray, collator);
        }
        this.log.println(" #### Testing Japan locale ####");
        this.oObj.loadDefaultCollator(new Locale("ja", "JP", ""), 0);
        collator = Collator.getInstance(new java.util.Locale("ja", "JP"));
        for (n = 19968; n < 20221; n = (int)((char)(n + 1))) {
            cArray[0] = n;
            cArray[1] = (char)(n + 1);
            bl &= this.testCompareSubstring(cArray, collator);
        }
        this.log.println(" #### Testing China locale ####");
        this.oObj.loadDefaultCollator(new Locale("zh", "CN", ""), 0);
        collator = Collator.getInstance(new java.util.Locale("zh", "CN"));
        for (n = 19968; n < 20221; n = (int)((char)(n + 1))) {
            cArray[0] = n;
            cArray[1] = (char)(n + 1);
            bl &= this.testCompareSubstring(cArray, collator);
        }
        this.log.println(" #### Testing Korean locale ####");
        this.oObj.loadDefaultCollator(new Locale("ko", "KR", ""), 0);
        collator = Collator.getInstance(new java.util.Locale("ko", "KR"));
        for (n = 19968; n < 20221; n = (int)((char)(n + 1))) {
            cArray[0] = n;
            cArray[1] = (char)(n + 1);
            bl &= this.testCompareSubstring(cArray, collator);
        }
        this.tRes.tested("compareSubstring()", bl);
    }

    public void _compareString() {
        int n;
        boolean bl = true;
        char[] cArray = new char[2];
        Collator collator = null;
        this.log.println(" #### Testing English locale ####");
        this.oObj.loadDefaultCollator(new Locale("en", "EN", ""), 0);
        collator = Collator.getInstance(new java.util.Locale("en", "EN"));
        for (n = 32; n < 127; n = (int)((char)(n + 1))) {
            cArray[0] = n;
            cArray[1] = (char)(n + 1);
            bl &= this.testCompareString(cArray, collator);
        }
        this.log.println(" #### Testing Russian locale ####");
        this.oObj.loadDefaultCollator(new Locale("ru", "RU", ""), 0);
        collator = Collator.getInstance(new java.util.Locale("ru", "RU"));
        for (n = 1040; n < 1104; n = (int)((char)(n + 1))) {
            cArray[0] = n;
            cArray[1] = (char)(n + 1);
            bl &= this.testCompareString(cArray, collator);
        }
        this.log.println(" #### Testing Japan locale ####");
        this.oObj.loadDefaultCollator(new Locale("ja", "JP", ""), 0);
        collator = Collator.getInstance(new java.util.Locale("ja", "JP"));
        for (n = 19968; n < 20221; n = (int)((char)(n + 1))) {
            cArray[0] = n;
            cArray[1] = (char)(n + 1);
            bl &= this.testCompareString(cArray, collator);
        }
        this.log.println(" #### Testing China locale ####");
        this.oObj.loadDefaultCollator(new Locale("zh", "CN", ""), 0);
        collator = Collator.getInstance(new java.util.Locale("zh", "CN"));
        for (n = 19968; n < 20221; n = (int)((char)(n + 1))) {
            cArray[0] = n;
            cArray[1] = (char)(n + 1);
            bl &= this.testCompareString(cArray, collator);
        }
        this.log.println(" #### Testing Korean locale ####");
        this.oObj.loadDefaultCollator(new Locale("ko", "KR", ""), 0);
        collator = Collator.getInstance(new java.util.Locale("ko", "KR"));
        for (n = 19968; n < 20221; n = (int)((char)(n + 1))) {
            cArray[0] = n;
            cArray[1] = (char)(n + 1);
            bl &= this.testCompareString(cArray, collator);
        }
        this.tRes.tested("compareString()", bl);
    }

    public boolean testCompareString(char[] cArray, Collator collator) {
        boolean bl = true;
        String string = "";
        String string2 = "_" + new String(new char[]{cArray[0]});
        String string3 = "_" + new String(new char[]{cArray[1]});
        int n = this.oObj.compareString(string2, string2);
        if (n != 0) {
            string = string + "  Testing collation of single equal characters (" + this.toUnicode(string2) + ") ... FAILED\n";
        }
        bl &= n == 0;
        n = this.oObj.compareString(string2, string3);
        if (n == 0) {
            string = string + "  Testing collation of single different characters (" + this.toUnicode(string2 + string3) + ") ... FAILED (0 returned)\n";
            string = string + "  Java collator returned " + collator.compare(string2, string3) + "\n";
            bl = false;
        } else {
            if ((n += this.oObj.compareString(string3, string2)) != 0) {
                string = string + "  Testing collation of single different characters (" + this.toUnicode(string2 + string3) + ") ... FAILED\n";
            }
            bl &= n == 0;
        }
        String string4 = new String(new char[]{cArray[0], cArray[0], cArray[1], cArray[1], cArray[1]});
        String string5 = new String(new char[]{cArray[0], cArray[0], cArray[0], cArray[1], cArray[1]});
        n = this.oObj.compareString(string4, string4);
        if (n != 0) {
            string = string + "  Testing collation of equal strings (" + this.toUnicode(string4) + ") ... FAILED\n";
        }
        bl &= n == 0;
        n = this.oObj.compareString(string4, string5);
        if (n == 0) {
            string = string + "  Testing collation of different strings ((" + this.toUnicode(string4) + "),(" + this.toUnicode(string5) + ")) ... FAILED (0 returned)\n";
            string = string + "  Java collator returned " + collator.compare(string4, string5) + "\n";
            bl = false;
        } else {
            if ((n += this.oObj.compareString(string5, string4)) != 0) {
                string = string + "  Testing collation of different strings ((" + this.toUnicode(string4) + "),(" + this.toUnicode(string5) + ")) ... FAILED\n";
            }
            bl &= n == 0;
        }
        if (!bl) {
            this.log.println(string);
        }
        return bl;
    }

    public boolean testCompareSubstring(char[] cArray, Collator collator) {
        boolean bl = true;
        String string = "";
        String string2 = new String(new char[]{cArray[0], cArray[0], cArray[1], cArray[1], cArray[1]});
        String string3 = new String(new char[]{cArray[0], cArray[0], cArray[0], cArray[1], cArray[1]});
        int n = this.oObj.compareSubstring(string2, 1, 2, string3, 2, 2);
        if (n != 0) {
            string = string + "  Testing collation of equal substrings (" + this.toUnicode(string2) + ") ... FAILED\n";
        }
        bl &= n == 0;
        n = this.oObj.compareSubstring(string2, 1, 2, string3, 1, 2);
        if (n == 0) {
            string = string + "  Testing collation of different strings ((" + this.toUnicode(string2.substring(1, 3)) + "),(" + this.toUnicode(string3.substring(1, 3)) + ")) ... FAILED (0 returned)\n";
            string = string + "  Java collator returned " + collator.compare(string2.substring(1, 3), string3.substring(1, 3)) + "\n";
            bl = false;
        } else {
            if ((n += this.oObj.compareSubstring(string3, 1, 2, string2, 1, 2)) != 0) {
                string = string + "  Testing collation of different strings ((" + this.toUnicode(string2) + "),(" + this.toUnicode(string3) + ")) ... FAILED\n";
            }
            bl &= n == 0;
        }
        if (!bl) {
            this.log.println(string);
        }
        return bl;
    }

    public String toUnicode(String string) {
        char[] cArray = string.toCharArray();
        String string2 = "";
        for (int i = 0; i < cArray.length; ++i) {
            if (i != 0) {
                string2 = string2 + ",";
            }
            string2 = string2 + Integer.toHexString(cArray[i]);
        }
        return string2;
    }
}

