/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XModel;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.RangeSelectionEvent;
import com.sun.star.sheet.XRangeSelection;
import com.sun.star.sheet.XRangeSelectionChangeListener;
import com.sun.star.sheet.XRangeSelectionListener;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.awt.AWTException;
import java.awt.Robot;
import java.io.PrintWriter;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.AccessibilityTools;
import util.utils;

public class _XRangeSelection
extends MultiMethodTest {
    public XRangeSelection oObj = null;
    MyRangeSelectionListener aListener = null;

    public void before() {
        this.aListener = new MyRangeSelectionListener(this.log);
        XModel xModel = (XModel)this.tEnv.getObjRelation("FirstModel");
        if (xModel == null) {
            throw new StatusException(Status.failed("Object relation FirstModel' not set."));
        }
        XWindow xWindow = xModel.getCurrentController().getFrame().getContainerWindow();
        XTopWindow xTopWindow = (XTopWindow)UnoRuntime.queryInterface(XTopWindow.class, (Object)xWindow);
        xTopWindow.toFront();
        utils.shortWait(500);
    }

    public void _abortRangeSelection() {
        this.requiredMethod("removeRangeSelectionChangeListener()");
        this.requiredMethod("removeRangeSelectionListener()");
        this.oObj.abortRangeSelection();
        this.tRes.tested("abortRangeSelection()", true);
    }

    public void _addRangeSelectionChangeListener() {
        this.oObj.addRangeSelectionChangeListener(this.aListener);
        this.tRes.tested("addRangeSelectionChangeListener()", true);
    }

    public void _addRangeSelectionListener() {
        this.oObj.addRangeSelectionListener(this.aListener);
        this.tRes.tested("addRangeSelectionListener()", true);
    }

    public void _removeRangeSelectionChangeListener() {
        this.oObj.removeRangeSelectionChangeListener(this.aListener);
        this.tRes.tested("removeRangeSelectionChangeListener()", true);
    }

    public void _removeRangeSelectionListener() {
        this.oObj.removeRangeSelectionListener(this.aListener);
        this.tRes.tested("removeRangeSelectionListener()", true);
    }

    public void _startRangeSelection() {
        this.requiredMethod("addRangeSelectionChangeListener()");
        this.requiredMethod("addRangeSelectionListener()");
        Point point = this.getSheetCenter();
        if (point == null) {
            throw new StatusException(Status.failed("Couldn't get the sheet center."));
        }
        PropertyValue[] propertyValueArray = new PropertyValue[3];
        propertyValueArray[0] = new PropertyValue();
        propertyValueArray[0].Name = "InitialValue";
        propertyValueArray[0].Value = "B3:D5";
        propertyValueArray[1] = new PropertyValue();
        propertyValueArray[1].Name = "Title";
        propertyValueArray[1].Value = "the title";
        propertyValueArray[2] = new PropertyValue();
        propertyValueArray[2].Name = "CloseOnMouseRelease";
        propertyValueArray[2].Value = Boolean.FALSE;
        this.oObj.startRangeSelection(propertyValueArray);
        utils.shortWait(1000);
        Point point2 = this.getCloser(point);
        if (point2 == null) {
            throw new StatusException(Status.failed("Couldn't get the close Button."));
        }
        this.clickOnSheet(point);
        utils.shortWait(5000);
        this.clickOnSheet(point2);
        utils.shortWait(5000);
        propertyValueArray[0].Value = "C4:E6";
        this.oObj.startRangeSelection(propertyValueArray);
        utils.shortWait(1000);
        propertyValueArray[0].Value = "C2:E3";
        this.oObj.startRangeSelection(propertyValueArray);
        utils.shortWait(1000);
        this.oObj.startRangeSelection(propertyValueArray);
        utils.shortWait(1000);
        this.oObj.abortRangeSelection();
        this.aListener.reset();
        System.out.println("Listener called: " + this.aListener.bAbortCalled);
        this.tRes.tested("startRangeSelection()", this.aListener.listenerCalled());
    }

    protected Point getSheetCenter() {
        Object object;
        Object object2;
        this.log.println("Trying to get AccessibleSpreadsheet");
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        XComponent xComponent = (XComponent)this.tEnv.getObjRelation("DOCUMENT");
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
        System.out.println("Name: " + xModel.getCurrentController().getFrame().getName());
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)this.tParam.getMSF(), xModel);
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)58);
        XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)AccessibilityTools.SearchedContext);
        this.log.println("Got " + utils.getImplName(xAccessibleComponent));
        Object object3 = null;
        try {
            object3 = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception exception) {
            this.log.println("Couldn't get toolkit");
            exception.printStackTrace(this.log);
            throw new StatusException("Couldn't get toolkit", exception);
        }
        XExtendedToolkit xExtendedToolkit = (XExtendedToolkit)UnoRuntime.queryInterface(XExtendedToolkit.class, object3);
        Object object4 = null;
        int n = xExtendedToolkit.getTopWindowCount();
        for (int i = 0; i < n; ++i) {
            try {
                object2 = xExtendedToolkit.getTopWindow(i);
                object = (XAccessible)UnoRuntime.queryInterface(XAccessible.class, object2);
                if (object != null) {
                    if (object.getAccessibleContext().getAccessibleName().indexOf("d2") <= 0) continue;
                    object4 = object2;
                    continue;
                }
                this.log.println("\t unknown window");
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (object4 == null) {
            System.out.println("No TopWindow :-(");
            return null;
        }
        Point point = xAccessibleComponent.getLocationOnScreen();
        object2 = xAccessibleComponent.getBounds();
        object = new Point();
        ((Point)object).X = point.X + ((Rectangle)object2).Width / 2;
        ((Point)object).Y = point.Y + ((Rectangle)object2).Height / 2;
        return object;
    }

    private Point getCloser(Point point) {
        Object object;
        Object object2;
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)this.tParam.getMSF();
        Object object3 = null;
        try {
            object3 = xMultiServiceFactory.createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception exception) {
            throw new StatusException("Could not create 'com.sun.star.awt.Toolkit'.", exception);
        }
        XExtendedToolkit xExtendedToolkit = (XExtendedToolkit)UnoRuntime.queryInterface(XExtendedToolkit.class, object3);
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xExtendedToolkit.getActiveTopWindow());
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        XTopWindow xTopWindow = null;
        XAccessibleComponent xAccessibleComponent = null;
        int n = xExtendedToolkit.getTopWindowCount();
        for (int i = 0; i < n; ++i) {
            try {
                XTopWindow xTopWindow2 = xExtendedToolkit.getTopWindow(i);
                object2 = (XAccessible)UnoRuntime.queryInterface(XAccessible.class, (Object)xTopWindow2);
                if (object2 != null) {
                    System.out.println("Name: " + object2.getAccessibleContext().getAccessibleName());
                    if (!object2.getAccessibleContext().getAccessibleName().startsWith("the title")) continue;
                    xTopWindow = xTopWindow2;
                    object = object2.getAccessibleContext();
                    xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, object);
                    if (xAccessibleComponent == null) {
                        System.out.println("!!!! MIST !!!!");
                        continue;
                    }
                    System.out.println("########## KLAPPT ########## ");
                    continue;
                }
                this.log.println("\t unknown window");
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (xTopWindow == null) {
            System.out.println("No TopWindow :-(");
            return null;
        }
        xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, xTopWindow);
        Rectangle rectangle = xWindow.getPosSize();
        boolean bl = false;
        while (!bl) {
            if (rectangle.X <= point.X && point.X <= rectangle.X + rectangle.Width) {
                if (rectangle.Y <= point.Y && point.Y <= rectangle.Y + rectangle.Height) {
                    rectangle.X += 10;
                    rectangle.Y += 10;
                    xWindow.setPosSize(rectangle.X, rectangle.Y, rectangle.Width, rectangle.Height, (short)3);
                    continue;
                }
                bl = true;
                continue;
            }
            bl = true;
        }
        object2 = xAccessibleComponent.getLocationOnScreen();
        object = new Point();
        ((Point)object).X = ((Point)object2).X + rectangle.Width - 2;
        ((Point)object).Y = ((Point)object2).Y + 5;
        System.out.println("Closer: " + ((Point)object).X + "   " + ((Point)object).Y);
        return object;
    }

    protected boolean clickOnSheet(Point point) {
        this.log.println("Clicking in the center of the AccessibleSpreadsheet");
        try {
            Robot robot = new Robot();
            robot.mouseMove(point.X, point.Y);
            robot.mousePress(16);
            utils.shortWait(1000);
            robot.mouseRelease(16);
            utils.shortWait(1000);
        }
        catch (AWTException aWTException) {
            this.log.println("couldn't press mouse button");
        }
        return true;
    }

    public static class MyRangeSelectionListener
    implements XRangeSelectionListener,
    XRangeSelectionChangeListener {
        boolean bAbortCalled = false;
        boolean bChangeCalled = false;
        boolean bDoneCalled = false;
        PrintWriter log = null;

        public MyRangeSelectionListener(PrintWriter printWriter) {
            this.log = printWriter;
        }

        public void aborted(RangeSelectionEvent rangeSelectionEvent) {
            this.log.println("Called 'aborted' with: " + rangeSelectionEvent.RangeDescriptor);
            this.bAbortCalled = true;
        }

        public void descriptorChanged(RangeSelectionEvent rangeSelectionEvent) {
            this.log.println("Called 'descriptorChanged' with: " + rangeSelectionEvent.RangeDescriptor);
            this.bChangeCalled = true;
        }

        public void done(RangeSelectionEvent rangeSelectionEvent) {
            this.log.println("Called 'done' with: " + rangeSelectionEvent.RangeDescriptor);
            this.bDoneCalled = true;
        }

        public boolean listenerCalled() {
            return this.bAbortCalled & this.bChangeCalled & this.bDoneCalled;
        }

        public void reset() {
            this.bAbortCalled = false;
            this.bChangeCalled = false;
            this.bDoneCalled = false;
        }

        public void disposing(EventObject eventObject) {
        }
    }
}

