/*
 * Decompiled with CFR 0.152.
 */
package ifc.text;

import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.text.XAutoTextGroup;
import com.sun.star.text.XTextRange;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.ValueComparer;

public class _XAutoTextGroup
extends MultiMethodTest {
    public XAutoTextGroup oObj = null;
    protected static int uniq = 0;
    protected String str = null;
    protected static final String pref = "XAutoTextGroup";
    protected XTextRange oRange = null;

    public void before() {
        this.str = pref + uniq++;
        String[] stringArray = this.oObj.getElementNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.log.println("  " + stringArray[i]);
            if (stringArray[i].toUpperCase().indexOf(pref.toUpperCase()) <= 0) continue;
            try {
                this.log.println("  ... removing ...");
                this.oObj.removeByName(stringArray[i]);
                continue;
            }
            catch (NoSuchElementException noSuchElementException) {
                this.log.println("Element '" + stringArray[i] + "' not found.");
            }
        }
        this.oRange = (XTextRange)this.tEnv.getObjRelation("TextRange");
        if (this.oRange == null) {
            throw new StatusException(Status.failed("No relation found"));
        }
    }

    public void _getTitles() {
        String[] stringArray = this.oObj.getTitles();
        this.tRes.tested("getTitles()", stringArray != null);
    }

    public void _insertNewByName() {
        boolean bl = false;
        try {
            String[] stringArray = this.oObj.getTitles();
            this.oObj.insertNewByName(this.str, "For " + this.str, this.oRange);
            String[] stringArray2 = this.oObj.getTitles();
            bl = !ValueComparer.equalValue(stringArray, stringArray2);
        }
        catch (ElementExistException elementExistException) {
            this.log.println("Exception occured while testing insertNewByName");
            elementExistException.printStackTrace(this.log);
            bl = false;
        }
        try {
            this.oObj.insertNewByName(this.str, "For " + this.str, this.oRange);
            this.log.println("com::sun::star::container::ElementExistsException wasn't thrown");
            this.oObj.removeByName(this.str);
            bl &= false;
        }
        catch (ElementExistException elementExistException) {
            bl &= true;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.log.println("Wrong exception was thrown :");
            noSuchElementException.printStackTrace(this.log);
            bl &= false;
        }
        this.tRes.tested("insertNewByName()", bl);
    }

    public void _removeByName() {
        this.requiredMethod("insertNewByName()");
        try {
            String[] stringArray = this.oObj.getTitles();
            this.oObj.removeByName(this.str);
            String[] stringArray2 = this.oObj.getTitles();
            this.tRes.tested("removeByName()", !ValueComparer.equalValue(stringArray, stringArray2));
        }
        catch (NoSuchElementException noSuchElementException) {
            this.log.println("Exception occured while testing removeByName");
            noSuchElementException.printStackTrace(this.log);
            this.tRes.tested("removeByName()", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _renameByName() {
        boolean bl;
        block94: {
            bl = false;
            try {
                String[] stringArray = this.oObj.getTitles();
                String[] stringArray2 = this.oObj.getElementNames();
                this.oObj.insertNewByName(this.str, "For " + this.str, this.oRange);
                this.oObj.insertNewByName(this.str + "dup", "For " + this.str, this.oRange);
                stringArray = this.oObj.getTitles();
                stringArray2 = this.oObj.getElementNames();
                bl = true;
            }
            catch (ElementExistException elementExistException) {
                this.log.println("Unexpected exception occured :");
                elementExistException.printStackTrace(this.log);
            }
            finally {
                if (bl) break block94;
                try {
                    this.oObj.removeByName(this.str);
                }
                catch (NoSuchElementException noSuchElementException) {}
                try {
                    this.oObj.removeByName(this.str + "dup");
                }
                catch (NoSuchElementException noSuchElementException) {}
                this.tRes.tested("renameByName()", false);
                return;
            }
        }
        try {
            this.oObj.renameByName(this.str, this.str + "dup", "For " + this.str);
            this.log.println("com::sun::star::container::ElementExistsException wasn't thrown");
            bl = false;
        }
        catch (ElementExistException elementExistException) {
            bl = true;
        }
        catch (IOException iOException) {
            this.log.println("Wrong exception was thrown :");
            iOException.printStackTrace(this.log);
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("Wrong exception was thrown :");
            illegalArgumentException.printStackTrace(this.log);
            bl = false;
        }
        finally {
            try {
                this.oObj.removeByName(this.str);
            }
            catch (NoSuchElementException noSuchElementException) {}
            try {
                this.oObj.removeByName(this.str + "dup");
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        try {
            this.oObj.renameByName("~" + this.str, this.str, this.str);
            this.log.println("com::sun::star::lang::IllegalArgumentException wasn't thrown");
            bl &= false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl &= true;
        }
        catch (ElementExistException elementExistException) {
            this.log.println("Unexpected exception :");
            elementExistException.printStackTrace(this.log);
            bl = false;
        }
        catch (IOException iOException) {
            this.log.println("Unexpected exception :");
            iOException.printStackTrace(this.log);
            bl = false;
        }
        finally {
            try {
                this.oObj.removeByName(this.str);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        try {
            this.oObj.insertNewByName(this.str, "For " + this.str, this.oRange);
            this.oObj.renameByName(this.str, this.str + "a", this.str + "b");
            bl &= this.oObj.hasByName(this.str + "a");
        }
        catch (ElementExistException elementExistException) {
            this.log.println("Exception occured while testing renameByName");
            elementExistException.printStackTrace(this.log);
            bl &= false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("Exception occured while testing renameByName");
            illegalArgumentException.printStackTrace(this.log);
            bl &= false;
        }
        catch (IOException iOException) {
            this.log.println("Exception occured while testing renameByName");
            iOException.printStackTrace(this.log);
            bl &= false;
        }
        finally {
            try {
                this.oObj.removeByName(this.str);
            }
            catch (NoSuchElementException noSuchElementException) {}
            try {
                this.oObj.removeByName(this.str + "a");
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        this.tRes.tested("renameByName()", bl);
    }
}

