/*
 * Decompiled with CFR 0.152.
 */
package ifc.view;

import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.view.XSelectionChangeListener;
import com.sun.star.view.XSelectionSupplier;
import java.util.Comparator;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.ValueComparer;

public class _XSelectionSupplier
extends MultiMethodTest {
    public XSelectionSupplier oObj = null;
    public boolean selectionChanged = false;
    Object[] selections = null;
    Comparator ObjCompare = null;
    XSelectionChangeListener listener = new MyChangeListener();

    protected void before() {
        this.selections = (Object[])this.tEnv.getObjRelation("Selections");
        if (this.selections == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'Selections'"));
        }
        this.ObjCompare = (Comparator)this.tEnv.getObjRelation("Comparer");
    }

    protected void after() {
        this.disposeEnvironment();
    }

    public void _addSelectionChangeListener() {
        boolean bl = true;
        try {
            this.selectionChanged = false;
            this.oObj.addSelectionChangeListener(this.listener);
            this.oObj.select(this.selections[0]);
            this.oObj.select(this.selections[1]);
            bl = this.selectionChanged;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("Exception occured during addSelectionChangeListener()");
            illegalArgumentException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("addSelectionChangeListener()", bl);
    }

    public void _select() {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        Object object = null;
        try {
            for (int i = 0; i < this.selections.length; ++i) {
                object = this.oObj.getSelection();
                bl2 = this.oObj.select(this.selections[i]);
                this.log.println("select #" + i + ": " + bl2);
                Object object2 = this.oObj.getSelection();
                if (bl2) {
                    if (this.ObjCompare != null) {
                        this.ObjCompare.compare(this.selections[i], object2);
                    } else {
                        bl3 = ValueComparer.equalValue(this.selections[i], object2);
                    }
                    this.log.println("selected object and current selection are equal: " + bl3);
                    if (!bl3 && this.selections[i] instanceof Object[] && ((Object[])this.selections[i])[0] instanceof Integer) {
                        this.log.println("Getting: " + (Integer)((Object[])object2)[0]);
                        this.log.println("Expected: " + (Integer)((Object[])this.selections[i])[0]);
                    }
                    bl &= bl3;
                    continue;
                }
                bl3 = ValueComparer.equalValue(object2, object);
                this.log.println("previous selection and current selection are equal: " + bl3);
                bl &= bl3;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("Exception occured during select()");
            illegalArgumentException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("select()", bl);
    }

    public void _removeSelectionChangeListener() {
        boolean bl = false;
        this.requiredMethod("addSelectionChangeListener()");
        try {
            this.selectionChanged = false;
            this.oObj.removeSelectionChangeListener(this.listener);
            this.oObj.select(this.selections[0]);
            this.oObj.select(this.selections[1]);
            bl = !this.selectionChanged;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("Exception occured during removeSelectionChangeListener()");
            illegalArgumentException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("removeSelectionChangeListener()", bl);
    }

    public void _getSelection() {
        this.requiredMethod("select()");
        this.tRes.tested("getSelection()", true);
    }

    public class MyChangeListener
    implements XSelectionChangeListener {
        public void disposing(EventObject eventObject) {
        }

        public void selectionChanged(EventObject eventObject) {
            _XSelectionSupplier.this.log.println("listener called");
            _XSelectionSupplier.this.selectionChanged = true;
        }
    }
}

