/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class ScAccessibleDocument
extends TestCase {
    static XComponent xSpreadsheetDoc = null;

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XAccessibleContext xAccessibleContext = null;
        printWriter.println("getting Drawpages");
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xSpreadsheetDoc);
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)testParameters.getMSF(), xModel);
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)13, "");
        AccessibilityTools.printAccessibleTree(printWriter, xAccessible, testParameters.getBool("DebugIsActive"));
        printWriter.println("ImplementationName " + utils.getImplName(xAccessibleContext));
        TestEnvironment testEnvironment = new TestEnvironment(xAccessibleContext);
        final XWindow xWindow2 = xWindow;
        testEnvironment.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                Rectangle rectangle = xWindow2.getPosSize();
                xWindow2.setPosSize(rectangle.X, rectangle.Y, rectangle.Height, rectangle.Width - 10, (short)15);
            }
        });
        return testEnvironment;
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xSheetDoc ");
        DesktopTools.closeDoc(xSpreadsheetDoc);
    }

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a spreadsheetdocument");
            String string = utils.getFullTestURL("calcshapes.sxc");
            printWriter.println("loading document " + string);
            xSpreadsheetDoc = sOfficeFactory.loadDocument(string);
            this.shortWait();
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document ", exception);
        }
    }

    private void shortWait() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            this.log.println("While waiting :" + interruptedException);
        }
    }
}

