/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XScenariosSupplier;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellAddress;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCell;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import ifc.util._XSortable;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;
import util.ValueComparer;

public class ScTableSheetObj
extends TestCase {
    static XSpreadsheetDocument xSheetDoc = null;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a sheetdocument");
            xSheetDoc = sOfficeFactory.createCalcDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xSheetDoc ");
        try {
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)xSheetDoc);
            xCloseable.close(true);
        }
        catch (CloseVetoException closeVetoException) {
            printWriter.println("Couldn't close document");
        }
        catch (DisposedException disposedException) {
            printWriter.println("Document already disposed");
        }
        catch (NullPointerException nullPointerException) {
            printWriter.println("Couldn't get XCloseable");
        }
        try {
            printWriter.println("Sleeping 500 Millis");
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        printWriter.println("... Done");
    }

    protected synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XInterface xInterface = null;
        printWriter.println("getting sheets");
        XSpreadsheets xSpreadsheets = xSheetDoc.getSheets();
        printWriter.println("getting a sheet");
        XSpreadsheet xSpreadsheet = null;
        XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
        try {
            xSpreadsheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)xIndexAccess.getByIndex(0));
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get a spreadsheet", wrappedTargetException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get a spreadsheet", indexOutOfBoundsException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get a spreadsheet", illegalArgumentException);
        }
        printWriter.println("filling some cells");
        try {
            xSpreadsheet.getCellByPosition(5, 5).setValue(15.0);
            xSpreadsheet.getCellByPosition(1, 4).setValue(10.0);
            xSpreadsheet.getCellByPosition(2, 0).setValue(-5.15);
            xSpreadsheet.getCellByPosition(8, 8).setFormula("= B5 + C1");
            xSpreadsheet.getCellByPosition(6, 6).setValue(3.0);
            xSpreadsheet.getCellByPosition(7, 6).setValue(3.0);
            xSpreadsheet.getCellByPosition(8, 6).setFormula("= SUM(G7:H7)");
            xSpreadsheet.getCellByPosition(9, 6).setFormula("= G7*I7");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(printWriter);
            throw new StatusException("Exception occurred while filling cells", indexOutOfBoundsException);
        }
        xInterface = (XInterface)UnoRuntime.queryInterface(XInterface.class, (Object)xSpreadsheet);
        printWriter.println("creating a new environment for object");
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        testEnvironment.addObjRelation("XCELLSERIES_FILLAUTO", new Boolean(false));
        testEnvironment.addObjRelation("CellRangeAddress", new CellRangeAddress(0, 6, 6, 8, 8));
        testEnvironment.addObjRelation("CellRangeSubAddress", new CellRangeAddress(0, 6, 6, 7, 8));
        testEnvironment.addObjRelation("XSheetAuditing.CellAddress", new CellAddress(0, 8, 6));
        testEnvironment.addObjRelation("XSheetAuditing.PrecedentCellAddress", new CellAddress(0, 7, 6));
        testEnvironment.addObjRelation("XSheetAuditing.DependentCellAddress", new CellAddress(0, 9, 6));
        testEnvironment.addObjRelation("XSheetLinkable.LinkSheet", "ScSheetLinksObj.sdc");
        XScenariosSupplier xScenariosSupplier = (XScenariosSupplier)UnoRuntime.queryInterface(XScenariosSupplier.class, (Object)testEnvironment.getTestObject());
        xScenariosSupplier.getScenarios().addNewByName("Scenario", new CellRangeAddress[]{new CellRangeAddress(0, 0, 0, 10, 10)}, "Comment");
        XSpreadsheet xSpreadsheet2 = null;
        try {
            xSpreadsheet2 = (XSpreadsheet)UnoRuntime.queryInterface(XSpreadsheet.class, xSpreadsheets.getByName("Scenario"));
        }
        catch (NoSuchElementException noSuchElementException) {
            printWriter.println("Couldn't get Scenario");
        }
        catch (WrappedTargetException wrappedTargetException) {
            printWriter.println("Couldn't get Scenario");
        }
        testEnvironment.addObjRelation("ScenarioSheet", xSpreadsheet2);
        printWriter.println("adding ObjRelation 'noArray' to avoid the test 'XArrayFormulaRange'");
        testEnvironment.addObjRelation("noArray", "ScTableSheetObj");
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xInterface);
        testEnvironment.addObjRelation("PropSet", xPropertySet);
        testEnvironment.addObjRelation("SHEET", xSpreadsheet);
        String[] stringArray = new String[]{"Sheet1.B5;Sheet1.C1", "Sheet1.B5;Sheet1.C1;Sheet1.F6", "Sheet1.A1 ... Sheet1.B1 ... Sheet1.B6 ... Sheet1.C2 ... Sheet1.D1 ... Sheet1.F1 ... Sheet1.F7 ... Sheet1.G1", "Sheet1.I7:J7;Sheet1.I9", "Sheet1.D4", "Sheet1.A5;Sheet1.C1", "Sheet1.A2"};
        testEnvironment.addObjRelation("XCellRangesQuery.EXPECTEDRESULTS", stringArray);
        try {
            testEnvironment.addObjRelation("MAKEENTRYINCELL", xSpreadsheet.getCellByPosition(15, 15));
            testEnvironment.addObjRelation("RANGEINDICES", new int[]{0, 0});
            testEnvironment.addObjRelation("EXPECTEDDEPENDENTVALUES", new int[]{0, 255, 0, 65535});
            testEnvironment.addObjRelation("EXPECTEDPRECEDENTVALUES", new int[]{0, 255, 0, 65535});
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            printWriter.println("Cannot add the necessary object relation for XFormulaQuery test.");
        }
        try {
            testEnvironment.addObjRelation("XSearchable.MAKEENTRYINCELL", new XCell[]{xSpreadsheet.getCellByPosition(15, 15), xSpreadsheet.getCellByPosition(15, 16)});
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(printWriter);
            printWriter.println("Cannot make required object relation 'XSearchable.MAKEENTRYINCELL'.");
        }
        final PrintWriter printWriter2 = printWriter;
        final XSpreadsheet xSpreadsheet3 = xSpreadsheet;
        testEnvironment.addObjRelation("SORTCHECKER", new _XSortable.XSortChecker(){
            PrintWriter out;
            {
                this.out = printWriter2;
            }

            public void setPrintWriter(PrintWriter printWriter) {
                this.out = printWriter;
            }

            public void prepareToSort() {
                try {
                    xSpreadsheet3.getCellByPosition(0, 0).setValue(4.0);
                    xSpreadsheet3.getCellByPosition(0, 1).setFormula("b");
                    xSpreadsheet3.getCellByPosition(0, 2).setValue(3.0);
                    xSpreadsheet3.getCellByPosition(0, 3).setValue(23.0);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.out.println("Exception while checking sort");
                }
            }

            public boolean checkSort(boolean bl, boolean bl2) {
                String[] stringArray;
                this.out.println("Sort checking...");
                boolean bl3 = false;
                String[] stringArray2 = new String[4];
                for (int i = 0; i < 4; ++i) {
                    try {
                        stringArray = xSpreadsheet3.getCellByPosition(0, i);
                        stringArray2[i] = stringArray.getFormula();
                        continue;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        this.out.println("Exception while checking sort");
                    }
                }
                if (bl) {
                    if (bl2) {
                        this.out.println("Sorting ascending");
                        String[] stringArray3 = new String[]{"3", "4", "23", "b"};
                        stringArray = new String[]{stringArray2[0], stringArray2[1], stringArray2[2], stringArray2[3]};
                        bl3 = ValueComparer.equalValue(stringArray, stringArray3);
                        this.out.println("Expected 3, 4, 23, b");
                        this.out.println("getting: " + stringArray2[0] + ", " + stringArray2[1] + ", " + stringArray2[2] + ", " + stringArray2[3]);
                    } else {
                        String[] stringArray4 = new String[]{"b", "23", "4", "3"};
                        stringArray = new String[]{stringArray2[0], stringArray2[1], stringArray2[2], stringArray2[3]};
                        bl3 = ValueComparer.equalValue(stringArray, stringArray4);
                        this.out.println("Expected b, 23, 4, 3");
                        this.out.println("getting: " + stringArray2[0] + ", " + stringArray2[1] + ", " + stringArray2[2] + ", " + stringArray2[3]);
                    }
                } else if (bl2) {
                    String[] stringArray5 = new String[]{"3", "4", "23", "b"};
                    bl3 = ValueComparer.equalValue(stringArray2, stringArray5);
                    this.out.println("Expected 3, 4, 23, b");
                    this.out.println("getting: " + stringArray2[0] + ", " + stringArray2[1] + ", " + stringArray2[2] + ", " + stringArray2[3]);
                } else {
                    String[] stringArray6 = new String[]{"b", "23", "4", "3"};
                    bl3 = ValueComparer.equalValue(stringArray2, stringArray6);
                    this.out.println("Expected b, 23, 4, 3");
                    this.out.println("getting: " + stringArray2[0] + ", " + stringArray2[1] + ", " + stringArray2[2] + ", " + stringArray2[3]);
                }
                if (bl3) {
                    this.out.println("Sorted correctly");
                } else {
                    this.out.println("Sorted uncorrectly");
                }
                return bl3;
            }
        });
        return testEnvironment;
    }
}

