/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XControlShape;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.form.XForm;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XViewPane;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.FormTools;
import util.SOfficeFactory;

public class ScViewPaneObj
extends TestCase {
    private static XSpreadsheetDocument xSpreadsheetDoc;
    private static SOfficeFactory SOF;
    private static XInterface oObj;

    public void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOF = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a spreadsheetdocument");
            xSpreadsheetDoc = SOF.createCalcDoc(null);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document ", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("disposing xSpreadsheetDocument");
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc);
        DesktopTools.closeDoc(xComponent);
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XInterface xInterface;
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xSpreadsheetDoc);
        XController xController = xModel.getCurrentController();
        XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xController);
        try {
            oObj = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)xIndexAccess.getByIndex(0));
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get by index", wrappedTargetException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get by index", indexOutOfBoundsException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Couldn't get by index", illegalArgumentException);
        }
        TestEnvironment testEnvironment = new TestEnvironment(oObj);
        testEnvironment.addObjRelation("DOCUMENT", UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc));
        testEnvironment.addObjRelation("XControlAccess.isSheet", Boolean.TRUE);
        XViewPane xViewPane = (XViewPane)UnoRuntime.queryInterface(XViewPane.class, (Object)oObj);
        CellRangeAddress cellRangeAddress = xViewPane.getVisibleRange();
        testEnvironment.addObjRelation("DATAAREA", cellRangeAddress);
        printWriter.println("adding relation for com.sun.star.view.XFormLayerAccess: XForm");
        XForm xForm = null;
        String string = "CommandButton";
        XControlShape xControlShape = null;
        try {
            printWriter.println("adding contol shape '" + string + "'");
            xInterface = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc);
            xControlShape = FormTools.createControlShape((XComponent)xInterface, 3000, 4500, 15000, 10000, string);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create following control shape : '" + string + "': ", exception);
        }
        try {
            printWriter.println("getting Drawpages");
            xInterface = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)xSpreadsheetDoc);
            XDrawPages xDrawPages = xInterface.getDrawPages();
            xDrawPages.insertNewByIndex(1);
            xDrawPages.insertNewByIndex(2);
            XDrawPage xDrawPage = (XDrawPage)AnyConverter.toObject((Type)new Type(XDrawPage.class), (Object)xDrawPages.getByIndex(0));
            if (xDrawPage == null) {
                printWriter.println("ERROR: could not get DrawPage: null");
            }
            xDrawPage.add(xControlShape);
            printWriter.println("getting XForm");
            XNameContainer xNameContainer = FormTools.getForms(xDrawPage);
            try {
                xForm = (XForm)AnyConverter.toObject((Type)new Type(XForm.class), (Object)xNameContainer.getByName("Standard"));
            }
            catch (WrappedTargetException wrappedTargetException) {
                printWriter.println("ERROR: could not XFormm 'Standard': " + wrappedTargetException.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                printWriter.println("ERROR: could not XFormm 'Standard': " + illegalArgumentException.toString());
            }
            catch (NoSuchElementException noSuchElementException) {
                printWriter.println("ERROR: could not XFormm 'Standard': " + noSuchElementException.toString());
            }
            if (xForm == null) {
                printWriter.println("ERROR: could not get XForm: null");
            }
            testEnvironment.addObjRelation("XFormLayerAccess.XForm", xForm);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            printWriter.println("ERROR: could not add ObjectRelation 'XFormLayerAccess.XForm': " + indexOutOfBoundsException.toString());
        }
        catch (WrappedTargetException wrappedTargetException) {
            printWriter.println("ERROR: could not add ObjectRelation 'XFormLayerAccess.XForm': " + wrappedTargetException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            printWriter.println("ERROR: could not add ObjectRelation 'XFormLayerAccess.XForm': " + illegalArgumentException.toString());
        }
        return testEnvironment;
    }
}

