/*
 * Decompiled with CFR 0.152.
 */
package mod._sm;

import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;

public class XMLImporter
extends TestCase {
    XComponent xMathDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            this.xMathDoc = sOfficeFactory.openDoc("smath", "_blank");
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xMathDoc ");
        this.xMathDoc.dispose();
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) throws StatusException {
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        XInterface xInterface = null;
        try {
            xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.comp.Math.XMLImporter");
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Unexpected exception", exception);
        }
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        testEnvironment.addObjRelation("TargetDocument", this.xMathDoc);
        String[][] stringArrayArray = new String[][]{{"start", "math:math", "xmlns:math", "CDATA", "http://www.w3.org/1998/Math/MathML"}, {"start", "math:semantics"}, {"start", "math:annotation", "math:encoding", "CDATA", "StarMath 5.0"}, {"chars", "a - b"}, {"end", "math:annotation"}, {"end", "math:semantics"}, {"end", "math:math"}};
        testEnvironment.addObjRelation("XDocumentHandler.XMLData", stringArrayArray);
        final PrintWriter printWriter2 = printWriter;
        final XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xMathDoc);
        testEnvironment.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            public boolean checkImport() {
                try {
                    String string = (String)xPropertySet.getPropertyValue("Formula");
                    printWriter2.println("Formula returned = '" + string + "'");
                    return "a - b".equals(string);
                }
                catch (Exception exception) {
                    printWriter2.println("Exception occured while checking filter :");
                    exception.printStackTrace(printWriter2);
                    return false;
                }
            }
        });
        return testEnvironment;
    }
}

