/*
 * Decompiled with CFR 0.152.
 */
package mod._svx;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Size;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.drawing.XShape;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.DrawTools;
import util.SOfficeFactory;
import util.utils;

public class AccessiblePresentationGraphicShape
extends TestCase {
    XComponent xDoc;
    XModel aModel;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a drawdoc");
            this.xDoc = sOfficeFactory.createImpressDoc(null);
            this.aModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xDoc);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xDrawDoc ");
        DesktopTools.closeDoc(this.xDoc);
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XAccessibleContext xAccessibleContext = null;
        XShape xShape = null;
        printWriter.println("creating a test environment");
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xDoc);
        try {
            xShape = (XShape)UnoRuntime.queryInterface(XShape.class, xMultiServiceFactory.createInstance("com.sun.star.presentation.GraphicObjectShape"));
        }
        catch (Exception exception) {
            throw new StatusException("couldn't create component", exception);
        }
        DrawTools.getShapes(DrawTools.getDrawPage(this.xDoc, 0)).add(xShape);
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xShape);
        try {
            xPropertySet.setPropertyValue("GraphicURL", utils.getFullTestURL("space-metal.jpg"));
            xPropertySet.setPropertyValue("IsEmptyPresentationObject", new Boolean(false));
        }
        catch (WrappedTargetException wrappedTargetException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (PropertyVetoException propertyVetoException) {
        }
        catch (UnknownPropertyException unknownPropertyException) {
            // empty catch block
        }
        AccessibilityTools accessibilityTools = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)testParameters.getMSF(), this.aModel);
        XAccessible xAccessible = AccessibilityTools.getAccessibleObject(xWindow);
        xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)52, "GraphicObject");
        TestEnvironment testEnvironment = new TestEnvironment(xAccessibleContext);
        final XShape xShape2 = xShape;
        testEnvironment.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            public void fireEvent() {
                try {
                    Size size = xShape2.getSize();
                    size.Width += 100;
                    xShape2.setSize(size);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
        printWriter.println("Implementation Name: " + utils.getImplName(xAccessibleContext));
        return testEnvironment;
    }
}

