/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XAutoTextContainer;
import com.sun.star.text.XText;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class SwXAutoTextGroup
extends TestCase {
    XTextDocument xTextDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a textdocument");
            this.xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    protected synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        Object object;
        XAutoTextContainer xAutoTextContainer;
        Object object2;
        Object object3;
        XInterface xInterface = null;
        printWriter.println("creating a test environment");
        try {
            object3 = (XMultiServiceFactory)testParameters.getMSF();
            object2 = object3.createInstance("com.sun.star.text.AutoTextContainer");
            xAutoTextContainer = (XAutoTextContainer)UnoRuntime.queryInterface(XAutoTextContainer.class, object2);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create AutoTextContainer", exception);
        }
        object3 = "myNewGroup2*1";
        object2 = (XAutoTextContainer)UnoRuntime.queryInterface(XAutoTextContainer.class, (Object)xAutoTextContainer);
        try {
            printWriter.println("removing element with name '" + (String)object3 + "'");
            object2.removeByName((String)object3);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            printWriter.println("adding element with name '" + (String)object3 + "'");
            object2.insertNewByName((String)object3);
        }
        catch (ElementExistException elementExistException) {
            elementExistException.printStackTrace(printWriter);
            throw new StatusException("could not insert '" + (String)object3 + "' into container", elementExistException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("could not insert '" + (String)object3 + "' into container", illegalArgumentException);
        }
        XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xAutoTextContainer);
        if (testParameters.getBool("DebugIsActive")) {
            object = xNameAccess.getElementNames();
            for (int i = 0; i < ((String[])object).length; ++i) {
                printWriter.println("ContainerNames[ " + i + "]: " + object[i]);
            }
        }
        try {
            xInterface = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)xNameAccess.getByName((String)object3));
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't get AutoTextGroup '" + (String)object3 + "'", exception);
        }
        printWriter.println("ImplementationName " + utils.getImplName(xInterface));
        printWriter.println("creating a new environment for AutoTextGroup object");
        object = new TestEnvironment(xInterface);
        XText xText = this.xTextDoc.getText();
        xText.insertString(xText.getStart(), "New AutoText", true);
        printWriter.println("adding TextRange as mod relation to environment");
        ((TestEnvironment)object).addObjRelation("TextRange", xText);
        return object;
    }
}

