/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XEndnotesSupplier;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.dbg;

public class SwXEndnoteProperties
extends TestCase {
    XTextDocument xTextDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a textdocument");
            this.xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) throws StatusException {
        XInterface xInterface;
        XEndnotesSupplier xEndnotesSupplier = null;
        XPropertySet xPropertySet = null;
        printWriter.println("Creating a test environment");
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDoc);
        printWriter.println("creating a endnote");
        try {
            xInterface = (XInterface)UnoRuntime.queryInterface(XInterface.class, xMultiServiceFactory.createInstance("com.sun.star.text.Endnote"));
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create endnote", exception);
        }
        XText xText = this.xTextDoc.getText();
        XTextCursor xTextCursor = xText.createTextCursor();
        printWriter.println("inserting the footnote into text document");
        XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xInterface);
        try {
            xText.insertTextContent(xTextCursor, xTextContent, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(printWriter);
            throw new StatusException("Couldn't insert the endnote", illegalArgumentException);
        }
        xEndnotesSupplier = (XEndnotesSupplier)UnoRuntime.queryInterface(XEndnotesSupplier.class, (Object)this.xTextDoc);
        xPropertySet = xEndnotesSupplier.getEndnoteSettings();
        dbg.printPropertiesNames(xPropertySet);
        TestEnvironment testEnvironment = new TestEnvironment(xPropertySet);
        return testEnvironment;
    }
}

