/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XSearchDescriptor;
import com.sun.star.util.XSearchable;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXTextSearch
extends TestCase {
    XTextDocument xTextDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a textdocument");
            this.xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XSearchDescriptor xSearchDescriptor = null;
        printWriter.println("creating a test environment");
        XText xText = this.xTextDoc.getText();
        XTextCursor xTextCursor = xText.createTextCursor();
        for (int i = 0; i < 5; ++i) {
            try {
                xText.insertString(xTextCursor, "SwXTextSearch...SwXTextSearch...SwXTextSearch", false);
                xText.insertControlCharacter(xTextCursor, (short)0, false);
                continue;
            }
            catch (Exception exception) {
                printWriter.println("EXCEPTION: " + exception);
            }
        }
        XSearchable xSearchable = (XSearchable)UnoRuntime.queryInterface(XSearchable.class, (Object)this.xTextDoc);
        XSearchDescriptor xSearchDescriptor2 = xSearchable.createSearchDescriptor();
        xSearchDescriptor2.setSearchString("SwXTextSearch");
        xSearchDescriptor = xSearchDescriptor2;
        printWriter.println("creating a new environment for TextSearch object");
        TestEnvironment testEnvironment = new TestEnvironment(xSearchDescriptor);
        printWriter.println("adding TextDocument as mod relation to environment");
        testEnvironment.addObjRelation("TEXTDOC", this.xTextDoc);
        return testEnvironment;
    }
}

