/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.view.XViewSettingsSupplier;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SwXViewSettings
extends TestCase {
    XTextDocument xTextDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a textdocument");
            this.xTextDoc = sOfficeFactory.createTextDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XInterface xInterface = null;
        printWriter.println("creating a test environment");
        xInterface = this.xTextDoc.getCurrentController();
        XViewSettingsSupplier xViewSettingsSupplier = (XViewSettingsSupplier)UnoRuntime.queryInterface(XViewSettingsSupplier.class, (Object)xInterface);
        xInterface = xViewSettingsSupplier.getViewSettings();
        printWriter.println("creating a new environment for ViewSettings object");
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        printWriter.println("adding TextDocument as mod relation to environment");
        testEnvironment.addObjRelation("TEXTDOC", this.xTextDoc);
        return testEnvironment;
    }
}

