/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Draw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XDocumentInfoSupplier;
import com.sun.star.document.XExporter;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Any;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.xml.sax.XDocumentHandler;
import ifc.document._XFilter;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;
import util.XMLTools;

public class XMLMetaExporter
extends TestCase {
    XComponent xDrawDoc = null;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        SOfficeFactory sOfficeFactory = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a drawdocument");
            this.xDrawDoc = sOfficeFactory.createDrawDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xDrawDoc ");
        this.xDrawDoc.dispose();
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) throws StatusException {
        Object object;
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        XInterface xInterface = null;
        FilterChecker filterChecker = new FilterChecker(printWriter);
        Any any = new Any(new Type(XDocumentHandler.class), (Object)filterChecker);
        try {
            xInterface = (XInterface)xMultiServiceFactory.createInstanceWithArguments("com.sun.star.comp.Draw.XMLMetaExporter", new Object[]{any});
            object = (XExporter)UnoRuntime.queryInterface(XExporter.class, (Object)xInterface);
            object.setSourceDocument(this.xDrawDoc);
            XDocumentInfoSupplier xDocumentInfoSupplier = (XDocumentInfoSupplier)UnoRuntime.queryInterface(XDocumentInfoSupplier.class, (Object)this.xDrawDoc);
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xDocumentInfoSupplier.getDocumentInfo());
            xPropertySet.setPropertyValue("Title", "XMLMetaExporter");
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Can't create component.", exception);
        }
        filterChecker.addTag(new XMLTools.Tag("office:document-meta"));
        filterChecker.addTagEnclosed(new XMLTools.Tag("office:meta"), new XMLTools.Tag("office:document-meta"));
        filterChecker.addTagEnclosed(new XMLTools.Tag("dc:title"), new XMLTools.Tag("office:meta"));
        filterChecker.addCharactersEnclosed("XMLMetaExporter", new XMLTools.Tag("dc:title"));
        printWriter.println("creating a new environment");
        object = new TestEnvironment(xInterface);
        ((TestEnvironment)object).addObjRelation("MediaDescriptor", XMLTools.createMediaDescriptor(new String[]{"FilterName"}, new Object[]{"sdraw: StarOffice XML (Draw)"}));
        ((TestEnvironment)object).addObjRelation("SourceDocument", this.xDrawDoc);
        ((TestEnvironment)object).addObjRelation("XFilter.Checker", filterChecker);
        return object;
    }

    protected class FilterChecker
    extends XMLTools.XMLChecker
    implements _XFilter.FilterChecker {
        public FilterChecker(PrintWriter printWriter) {
            super(printWriter, true);
        }

        public boolean checkFilter() {
            return this.check();
        }
    }
}

