/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.tooling.converter;

import com.sun.star.tooling.DirtyTags.DirtyTagWrapper;
import com.sun.star.tooling.converter.Converter;
import com.sun.star.tooling.converter.DataHandler;
import com.sun.star.tooling.converter.DataWriter;
import com.sun.star.tooling.converter.ExtMap;
import com.sun.star.tooling.converter.OutputHandler;
import com.sun.star.tooling.languageResolver.LanguageResolver;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public class XLIFFWriter
extends DataWriter {
    private static final String[] sourceLineNames = new String[]{"Project", "SourceFile", "Dummy", "ResType", "GID", "LID", "HID", "Platform", "Width", "SourceLanguageID", "SourceText", "SourceHText", "SourceQText", "SourceTitle", "TimeStamp"};
    private static final String[] targetLineNames = new String[]{"Project", "SourceFile", "Dummy", "ResType", "GID", "LID", "HID", "Platform", "Width", "TargetLanguageID", "TargetText", "TargetHText", "TargetQText", "TargetTitle", "TimeStamp"};
    private static final String[] outLineNames = new String[]{"BlockNr", "Project", "SourceFile", "Dummy", "ResType", "GID", "LID", "HID", "Platform", "Width", "SourceLanguageID", "SourceText", "SourceHText", "SourceQText", "SourceTitle", "TargetLanguageID", "TargetText", "TargetHText", "TargetQText", "TargetTitle", "TimeStamp"};
    private final Map data = new ExtMap(outLineNames, null);
    boolean isFirst = true;
    LanguageResolver languageResolver = new LanguageResolver();

    public XLIFFWriter(BufferedOutputStream bufferedOutputStream, String string) throws IOException {
        super(bufferedOutputStream, string);
    }

    public void getDatafrom(DataHandler dataHandler) throws IOException {
        dataHandler.putDataTo(this.data);
    }

    private final boolean isUsed(String string) {
        return !"".equals(string);
    }

    private final String xmlString(String string) throws IOException {
        if (string == null) {
            return string;
        }
        String string2 = string;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '&') {
                string2 = string2.substring(0, i) + "&amp;" + string2.substring(i + 1);
                continue;
            }
            if (string2.charAt(i) == '<') {
                string2 = string2.substring(0, i) + "&lt;" + string2.substring(i + 1);
                continue;
            }
            if (string2.charAt(i) == '>') {
                string2 = string2.substring(0, i) + "&gt;" + string2.substring(i + 1);
                continue;
            }
            if (string2.charAt(i) == '\"') {
                string2 = string2.substring(0, i) + "&quot;" + string2.substring(i + 1);
                continue;
            }
            if (string2.charAt(i) != '\'') continue;
            string2 = string2.substring(0, i) + "&apos;" + string2.substring(i + 1);
        }
        return string2;
    }

    public void close() throws IOException {
        this.writeTrailer();
        super.close();
    }

    public void writeData() throws IOException {
        if (this.isFirst) {
            this.writeHeader();
            this.isFirst = false;
        }
        try {
            this.writeTransUnit();
        }
        catch (DirtyTagWrapper.TagWrapperException tagWrapperException) {
            // empty catch block
        }
    }

    private void writeHeader() throws IOException {
        this.write(this.getHeader());
    }

    private void writeTrailer() throws IOException {
        this.write(this.getTrailer());
    }

    private void writeTransUnit() throws IOException, DirtyTagWrapper.TagWrapperException {
        try {
            StringBuffer stringBuffer = new StringBuffer(1000);
            StringBuffer stringBuffer2 = new StringBuffer(200);
            String string = "";
            int n = 0;
            if (this.data == null) {
                OutputHandler.out("error");
            }
            if (!this.data.get("SourceText").equals("") && !this.data.get("SourceText").equals(" ")) {
                ++n;
            }
            if (!this.data.get("SourceQText").equals("") && !this.data.get("SourceQText").equals(" ")) {
                ++n;
            }
            if (!this.data.get("SourceTitle").equals("") && !this.data.get("SourceTitle").equals(" ")) {
                ++n;
            }
            if (!this.data.get("SourceText").equals("") && !this.data.get("SourceText").equals(" ")) {
                string = "res";
                stringBuffer2.append("\t\t\t\t<context-group name=\"StarOffice Attributes\">\n");
                if (this.isUsed((String)this.data.get("ResType"))) {
                    stringBuffer2.append("\t\t\t\t\t<context context-type=\"DBType\">" + this.xmlString((String)this.data.get("ResType")) + "</context>\n");
                }
                if (this.isUsed((String)this.data.get("Project"))) {
                    stringBuffer2.append("\t\t\t\t\t<context context-type=\"Project\">" + this.xmlString((String)this.data.get("Project")) + "</context>\n");
                }
                if (this.isUsed((String)this.data.get("SourceFile"))) {
                    stringBuffer2.append("\t\t\t\t\t<context context-type=\"Filename\">" + this.xmlString((String)this.data.get("SourceFile")) + "</context>\n");
                }
                if (this.isUsed((String)this.data.get("SourceHText"))) {
                    stringBuffer2.append("\t\t\t\t\t<context context-type=\"SourceHelpText\">" + this.xmlString((String)this.data.get("SourceHText")) + "</context>\n");
                }
                if (this.isUsed((String)this.data.get("TargetHText"))) {
                    stringBuffer2.append("\t\t\t\t\t<context context-type=\"TargetHelpText\">" + this.xmlString((String)this.data.get("TargetHText")) + "</context>\n");
                }
                if (this.isUsed((String)this.data.get("ResType"))) {
                    stringBuffer2.append("\t\t\t\t\t<context context-type=\"Type\">" + this.xmlString((String)this.data.get("ResType")) + "</context>\n");
                }
                if (this.isUsed((String)this.data.get("GID"))) {
                    stringBuffer2.append("\t\t\t\t\t<context context-type=\"GID\">" + this.xmlString((String)this.data.get("GID")) + "</context>\n");
                }
                if (this.isUsed((String)this.data.get("LID"))) {
                    stringBuffer2.append("\t\t\t\t\t<context context-type=\"LID\">" + this.xmlString((String)this.data.get("LID")) + "</context>\n");
                }
                if (this.isUsed((String)this.data.get("HID"))) {
                    stringBuffer2.append("\t\t\t\t\t<context context-type=\"HID\">" + this.xmlString((String)this.data.get("HID")) + "</context>\n");
                }
                if (this.isUsed((String)this.data.get("Platform"))) {
                    stringBuffer2.append("\t\t\t\t\t<context context-type=\"Platform\">" + this.xmlString((String)this.data.get("Platform")) + "</context>\n");
                }
                if (this.isUsed((String)this.data.get("Width"))) {
                    stringBuffer2.append("\t\t\t\t\t<context context-type=\"Width\">" + this.xmlString((String)this.data.get("Width")) + "</context>\n");
                }
                stringBuffer2.append("\t\t\t\t</context-group>\n\t\t\t</trans-unit>\n");
                stringBuffer.append("\t\t\t<trans-unit id=\"" + this.data.get("BlockNr") + ":" + n + "\" restype=\"" + string + "\" translate=\"yes\">\n");
                if (this.isUsed((String)this.data.get("SourceText"))) {
                    stringBuffer.append("\t\t\t\t<source xml:lang=\"" + this.languageResolver.getRFCFromISO((String)this.data.get("SourceLanguageID")) + "\">" + DirtyTagWrapper.wrapString((String)this.data.get("SourceText")) + "</source>\n");
                }
                if (this.isUsed((String)this.data.get("TargetText"))) {
                    stringBuffer.append("\t\t\t\t<target state=\"to_translate\" xml:lang=\"" + this.languageResolver.getRFCFromISO((String)this.data.get("TargetLanguageID")) + "\">" + DirtyTagWrapper.wrapString((String)this.data.get("TargetText")) + "</target>\n");
                }
                stringBuffer.append(stringBuffer2);
                Converter.countLine();
            }
            if (!this.data.get("SourceQText").equals("") && !this.data.get("SourceQText").equals(" ")) {
                string = "res-QuickHelp";
                stringBuffer.append("\t\t\t<trans-unit id=\"" + this.data.get("BlockNr") + ":" + n + "\" restype=\"" + string + "\" translate=\"yes\">\n");
                if (this.isUsed((String)this.data.get("SourceQText"))) {
                    stringBuffer.append("\t\t\t\t<source xml:lang=\"" + this.languageResolver.getRFCFromISO((String)this.data.get("SourceLanguageID")) + "\">" + DirtyTagWrapper.wrapString((String)this.data.get("SourceQText")) + "</source>\n");
                }
                if (this.isUsed((String)this.data.get("TargetQText"))) {
                    stringBuffer.append("\t\t\t\t<target state=\"to_translate\" xml:lang=\"" + this.languageResolver.getRFCFromISO((String)this.data.get("TargetLanguageID")) + "\">" + DirtyTagWrapper.wrapString((String)this.data.get("TargetQText")) + "</target>\n");
                }
                stringBuffer.append(stringBuffer2);
                Converter.countLine();
            }
            if (!this.data.get("SourceTitle").equals("") && !this.data.get("SourceTitle").equals(" ")) {
                string = "res-Title";
                stringBuffer.append("\t\t\t<trans-unit id=\"" + this.data.get("BlockNr") + ":" + n + "\" restype=\"" + string + "\" translate=\"yes\">\n");
                if (this.isUsed((String)this.data.get("SourceTitle"))) {
                    stringBuffer.append("\t\t\t\t<source xml:lang=\"" + this.languageResolver.getRFCFromISO((String)this.data.get("SourceLanguageID")) + "\">" + DirtyTagWrapper.wrapString((String)this.data.get("SourceTitle")) + "</source>\n");
                }
                if (this.isUsed((String)this.data.get("TargetTitle"))) {
                    stringBuffer.append("\t\t\t\t<target state=\"to_translate\" xml:lang=\"" + this.languageResolver.getRFCFromISO((String)this.data.get("TargetLanguageID")) + "\">" + DirtyTagWrapper.wrapString((String)this.data.get("TargetTitle")) + "</target>\n");
                }
                stringBuffer.append(stringBuffer2);
                Converter.countLine();
            }
            this.write(stringBuffer.toString());
        }
        catch (Exception exception) {
            OutputHandler.log(exception.getMessage());
        }
    }

    private String getHeader() throws UnsupportedEncodingException {
        return new String((this.getProcessingInstructionTag() + this.getDTDLine() + this.openVersionLine() + this.openFileLine() + this.getHeaderTag() + this.openBodyTag()).getBytes(), "UTF8");
    }

    private String getTrailer() {
        return this.closeBodyTag() + this.closeFileLine() + this.closeVersionLine();
    }

    private String getProcessingInstructionTag() {
        String string = "<?";
        String string2 = "xml ";
        String string3 = "version=\"1.0\" ";
        String string4 = "encoding=\"UTF-8\"";
        String string5 = "?>";
        return string + string2 + string3 + string4 + string5 + '\n';
    }

    private String getDTDLine() {
        String string = "<!DOCTYPE ";
        String string2 = "xliff ";
        String string3 = "PUBLIC \"-//XLIFF//DTD XLIFF//EN\" \"http://www.oasis-open.org/committees/xliff/documents/xliff.dtd\">";
        String string4 = ">";
        return string + string2 + string3 + '\n';
    }

    private String openVersionLine() {
        return "<xliff version=\"1.0\">\n";
    }

    private String closeVersionLine() {
        return "</xliff>";
    }

    private String openFileLine() {
        String string = "\t<file";
        String string2 = " datatype=\"STAROFFICE\"";
        String string3 = " date=\"" + this.data.get("TimeStamp") + "\"";
        String string4 = " original=\"" + this.data.get("SourceFile") + "\"";
        String string5 = "";
        String string6 = "";
        try {
            string5 = " source-language=\"" + this.languageResolver.getRFCFromISO((String)this.data.get("SourceLanguageID")) + "\" ";
            string6 = " target-language=\"" + this.languageResolver.getRFCFromISO((String)this.data.get("TargetLanguageID")) + "\" ";
        }
        catch (LanguageResolver.LanguageResolvingException languageResolvingException) {
            OutputHandler.out(languageResolvingException.getMessage());
        }
        String string7 = ">";
        return string + string2 + string3 + string4 + string5 + string6 + string7;
    }

    private String closeFileLine() {
        return "\t</file>";
    }

    private String getHeaderTag() {
        return "<header></header>\n";
    }

    private String openBodyTag() {
        return "\t\t<body>\n";
    }

    private String closeBodyTag() {
        return "\t\t</body>";
    }

    protected void writeData(Map[] mapArray) throws IOException {
    }

    protected void getDataFrom(DataHandler dataHandler) {
    }
}

