/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.tooling.languageResolver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.ListIterator;

public class LanguageResolver {
    private static final int ISO = 2;
    private static final int LANGID = 0;
    private static final int LANGNAME = 1;
    private static final int RFC3066 = 3;
    ArrayList languages = new ArrayList();

    public LanguageResolver() throws IOException {
        String string;
        String string2 = "com/sun/star/tooling/languageResolver/lang.map";
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(string2);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            this.languages.add(string.split(","));
        }
    }

    public String getNrFromISO(String string) throws LanguageResolvingException {
        if ("".equals(string)) {
            return "";
        }
        ListIterator listIterator = this.languages.listIterator();
        String[] stringArray = new String[5];
        while (string != "" && listIterator.hasNext()) {
            stringArray = (String[])listIterator.next();
            if (!stringArray[2].equals(string)) continue;
            return stringArray[0];
        }
        throw new LanguageResolvingException("Can not find ISO Code: " + string);
    }

    public String getISOfromNr(String string) throws LanguageResolvingException {
        if ("".equals(string)) {
            return "";
        }
        ListIterator listIterator = this.languages.listIterator();
        String[] stringArray = new String[5];
        while (listIterator.hasNext()) {
            stringArray = (String[])listIterator.next();
            if (!stringArray[0].equals(string)) continue;
            return stringArray[2];
        }
        throw new LanguageResolvingException("Can not find Language Id: " + string);
    }

    public String getRFCFromISO(String string) throws LanguageResolvingException {
        if ("".equals(string)) {
            return "";
        }
        ListIterator listIterator = this.languages.listIterator();
        String[] stringArray = new String[5];
        while (listIterator.hasNext()) {
            stringArray = (String[])listIterator.next();
            if (!stringArray[2].equals(string)) continue;
            return stringArray[3];
        }
        throw new LanguageResolvingException("Can not find ISO Code: " + string);
    }

    public String getISOFromRFC(String string) throws LanguageResolvingException {
        if ("".equals(string)) {
            return "";
        }
        ListIterator listIterator = this.languages.listIterator();
        String[] stringArray = new String[5];
        while (listIterator.hasNext()) {
            stringArray = (String[])listIterator.next();
            if (!stringArray[3].equals(string)) continue;
            return stringArray[2];
        }
        throw new LanguageResolvingException("Can not find Language Id: " + string);
    }

    public class LanguageResolvingException
    extends Exception {
        public LanguageResolvingException() {
        }

        public LanguageResolvingException(String string) {
            super(string);
        }

        public LanguageResolvingException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public LanguageResolvingException(Throwable throwable) {
            super(throwable);
        }
    }
}

