/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.repository;

import org.jfree.repository.ContentItem;
import org.jfree.repository.MimeRegistry;
import org.jfree.util.StringUtils;

public class DefaultMimeRegistry
implements MimeRegistry {
    public String getMimeType(ContentItem item) {
        String name = item.getName();
        if (name == null) {
            return "application/octet-stream";
        }
        if (StringUtils.endsWithIgnoreCase((String)name, (String)".png")) {
            return "image/png";
        }
        if (StringUtils.endsWithIgnoreCase((String)name, (String)".jpg")) {
            return "image/jpeg";
        }
        if (StringUtils.endsWithIgnoreCase((String)name, (String)".jpeg")) {
            return "image/jpeg";
        }
        if (StringUtils.endsWithIgnoreCase((String)name, (String)".gif")) {
            return "image/gif";
        }
        if (StringUtils.endsWithIgnoreCase((String)name, (String)".pdf")) {
            return "application/pdf";
        }
        if (StringUtils.endsWithIgnoreCase((String)name, (String)".txt")) {
            return "text/plain";
        }
        if (StringUtils.endsWithIgnoreCase((String)name, (String)".html")) {
            return "text/html";
        }
        if (StringUtils.endsWithIgnoreCase((String)name, (String)".htm")) {
            return "text/html";
        }
        if (StringUtils.endsWithIgnoreCase((String)name, (String)".css")) {
            return "text/css";
        }
        return "application/octet-stream";
    }

    public String getSuffix(String mimeType) {
        if ("image/png".equals(mimeType)) {
            return "png";
        }
        if ("image/jpeg".equals(mimeType)) {
            return "jpg";
        }
        if ("image/jpg".equals(mimeType)) {
            return "jpg";
        }
        if ("image/gif".equals(mimeType)) {
            return "gif";
        }
        if ("text/html".equals(mimeType)) {
            return "html";
        }
        if ("text/plain".equals(mimeType)) {
            return "txt";
        }
        if ("text/css".equals(mimeType)) {
            return "css";
        }
        if ("application/pdf".equals(mimeType)) {
            return "pdf";
        }
        return "dat";
    }
}

