/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.repository;

import org.jfree.repository.ContentIOException;
import org.jfree.repository.ContentLocation;
import org.jfree.repository.MimeRegistry;
import org.jfree.repository.NameGenerator;
import org.jfree.repository.Repository;

public class DefaultNameGenerator
implements NameGenerator {
    private ContentLocation location;
    private String defaultNameHint;
    private String defaultSuffix;

    public DefaultNameGenerator(ContentLocation location) {
        this(location, "file");
    }

    public DefaultNameGenerator(ContentLocation location, String defaultNameHint) {
        this(location, defaultNameHint, null);
    }

    public DefaultNameGenerator(ContentLocation location, String defaultNameHint, String defaultSuffix) {
        if (location == null) {
            throw new NullPointerException();
        }
        if (defaultNameHint == null) {
            throw new NullPointerException();
        }
        this.location = location;
        this.defaultNameHint = defaultNameHint;
        this.defaultSuffix = defaultSuffix;
    }

    public String generateName(String nameHint, String mimeType) throws ContentIOException {
        String name = nameHint != null ? nameHint : this.defaultNameHint;
        String suffix = this.defaultSuffix != null ? this.defaultSuffix : this.getSuffixForType(mimeType, this.location);
        String firstFileName = name + "." + suffix;
        if (!this.location.exists(firstFileName)) {
            return firstFileName;
        }
        int counter = 0;
        while (true) {
            if (counter < 0) {
                throw new ContentIOException();
            }
            String filename = name + counter + "." + suffix;
            if (!this.location.exists(filename)) {
                return filename;
            }
            ++counter;
        }
    }

    private String getSuffixForType(String mimeType, ContentLocation location) {
        Repository repository = location.getRepository();
        MimeRegistry mimeRegistry = repository.getMimeRegistry();
        return mimeRegistry.getSuffix(mimeType);
    }
}

