/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.repository;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.jfree.repository.ContentEntity;
import org.jfree.repository.ContentIOException;
import org.jfree.repository.ContentItem;
import org.jfree.repository.ContentLocation;
import org.jfree.repository.Repository;

public class RepositoryUtilities {
    private RepositoryUtilities() {
    }

    public static ContentEntity getEntity(Repository repository, String[] name) throws ContentIOException {
        if (name.length == 0) {
            return repository.getRoot();
        }
        ContentLocation node = repository.getRoot();
        for (int i = 0; i < name.length - 1; ++i) {
            String nameItem = name[i];
            ContentEntity entry = node.getEntry(nameItem);
            if (!(entry instanceof ContentLocation)) {
                throw new ContentIOException("No such item.");
            }
            node = (ContentLocation)entry;
        }
        return node.getEntry(name[name.length - 1]);
    }

    public static ContentItem createItem(Repository repository, String[] name) throws ContentIOException {
        if (name.length == 0) {
            throw new IllegalArgumentException("Empty name not permitted.");
        }
        ContentLocation node = repository.getRoot();
        for (int i = 0; i < name.length - 1; ++i) {
            String nameItem = name[i];
            if (!node.exists(nameItem)) {
                node = node.createLocation(nameItem);
                continue;
            }
            ContentEntity entry = node.getEntry(nameItem);
            if (!(entry instanceof ContentLocation)) {
                throw new ContentIOException("No such item.");
            }
            node = (ContentLocation)entry;
        }
        return node.createItem(name[name.length - 1]);
    }

    public static ContentLocation createLocation(Repository repository, String[] name) throws ContentIOException {
        if (name.length == 0) {
            throw new IllegalArgumentException("Empty name not permitted.");
        }
        ContentLocation node = repository.getRoot();
        for (int i = 0; i < name.length - 1; ++i) {
            String nameItem = name[i];
            if (!node.exists(nameItem)) {
                node = node.createLocation(nameItem);
                continue;
            }
            ContentEntity entry = node.getEntry(nameItem);
            if (!(entry instanceof ContentLocation)) {
                throw new ContentIOException("No such item.");
            }
            node = (ContentLocation)entry;
        }
        return node.createLocation(name[name.length - 1]);
    }

    public static String[] split(String name, String separator) {
        StringTokenizer strtok = new StringTokenizer(name, separator, false);
        int tokenCount = strtok.countTokens();
        String[] retval = new String[tokenCount];
        int i = 0;
        while (strtok.hasMoreTokens()) {
            retval[i] = strtok.nextToken();
            ++i;
        }
        return retval;
    }

    public static String[] buildNameArray(ContentEntity entity) {
        LinkedList<String> collector = new LinkedList<String>();
        while (entity != null) {
            ContentLocation parent = entity.getParent();
            if (parent != null) {
                collector.add(0, entity.getName());
            }
            entity = parent;
        }
        return collector.toArray(new String[collector.size()]);
    }

    public static String buildName(ContentEntity entity, String separator) {
        int maxIdx;
        ArrayList<String> collector = new ArrayList<String>();
        while (entity != null) {
            ContentLocation parent = entity.getParent();
            if (parent != null) {
                collector.add(entity.getName());
            }
            entity = parent;
        }
        StringBuffer builder = new StringBuffer();
        for (int i = maxIdx = collector.size() - 1; i >= 0; --i) {
            String s = (String)collector.get(i);
            if (i != maxIdx) {
                builder.append("/");
            }
            builder.append(s);
        }
        return builder.toString();
    }
}

