/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.repository.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jfree.repository.ContentIOException;
import org.jfree.repository.ContentItem;
import org.jfree.repository.ContentLocation;
import org.jfree.repository.file.FileContentEntity;
import org.jfree.repository.file.FileRepository;

public class FileContentItem
extends FileContentEntity
implements ContentItem {
    public FileContentItem(ContentLocation parent, File backend) {
        super(parent, backend);
    }

    public String getMimeType() throws ContentIOException {
        FileRepository fileRepository = (FileRepository)this.getRepository();
        return fileRepository.getMimeRegistry().getMimeType(this);
    }

    public OutputStream getOutputStream() throws ContentIOException, IOException {
        return new FileOutputStream(this.getBackend());
    }

    public InputStream getInputStream() throws ContentIOException, IOException {
        return new FileInputStream(this.getBackend());
    }

    public boolean isReadable() {
        return this.getBackend().canRead();
    }

    public boolean isWriteable() {
        return this.getBackend().canWrite();
    }
}

