/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.repository.file;

import java.io.File;
import java.io.IOException;
import org.jfree.io.IOUtils;
import org.jfree.repository.ContentCreationException;
import org.jfree.repository.ContentEntity;
import org.jfree.repository.ContentIOException;
import org.jfree.repository.ContentItem;
import org.jfree.repository.ContentLocation;
import org.jfree.repository.Repository;
import org.jfree.repository.file.FileContentEntity;
import org.jfree.repository.file.FileContentItem;

public class FileContentLocation
extends FileContentEntity
implements ContentLocation {
    public FileContentLocation(ContentLocation parent, File backend) {
        super(parent, backend);
    }

    public FileContentLocation(Repository repository, File backend) {
        super(repository, backend);
    }

    public ContentEntity[] listContents() throws ContentIOException {
        File file = this.getBackend();
        File[] files = file.listFiles();
        ContentEntity[] entities = new ContentEntity[files.length];
        for (int i = 0; i < files.length; ++i) {
            File child = files[i];
            if (child.isDirectory()) {
                entities[i] = new FileContentLocation(this, child);
                continue;
            }
            if (!child.isFile()) continue;
            entities[i] = new FileContentLocation(this, child);
        }
        return entities;
    }

    public ContentEntity getEntry(String name) throws ContentIOException {
        File file = this.getBackend();
        File child = new File(file, name);
        if (!child.exists()) {
            throw new ContentIOException("Not found.");
        }
        try {
            if (IOUtils.getInstance().isSubDirectory(file, child)) {
                throw new ContentIOException("Not sub-directory");
            }
        }
        catch (IOException e) {
            throw new ContentIOException("IO Error.");
        }
        if (child.isDirectory()) {
            return new FileContentLocation(this, child);
        }
        if (child.isFile()) {
            return new FileContentItem(this, child);
        }
        throw new ContentIOException("Not File nor directory.");
    }

    public ContentItem createItem(String name) throws ContentCreationException {
        File file = this.getBackend();
        File child = new File(file, name);
        if (child.exists()) {
            throw new ContentCreationException("File already exists.");
        }
        try {
            if (!child.createNewFile()) {
                throw new ContentCreationException("Unable to create");
            }
            return new FileContentItem(this, child);
        }
        catch (IOException e) {
            throw new ContentCreationException("IOError while create");
        }
    }

    public ContentLocation createLocation(String name) throws ContentCreationException {
        File file = this.getBackend();
        File child = new File(file, name);
        if (child.exists()) {
            throw new ContentCreationException("File already exists.");
        }
        if (!child.mkdir()) {
            throw new ContentCreationException("Unable to create");
        }
        return new FileContentLocation(this, child);
    }

    public boolean exists(String name) {
        File file = this.getBackend();
        File child = new File(file, name);
        return child.exists();
    }
}

