/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.repository.stream;

import org.jfree.repository.ContentCreationException;
import org.jfree.repository.ContentEntity;
import org.jfree.repository.ContentIOException;
import org.jfree.repository.ContentItem;
import org.jfree.repository.ContentLocation;
import org.jfree.repository.Repository;
import org.jfree.repository.stream.StreamContentItem;
import org.jfree.repository.stream.StreamRepository;

public class StreamContentLocation
implements ContentLocation {
    private ContentItem contentItem;
    private StreamRepository repository;

    public StreamContentLocation(StreamRepository repository) {
        this.repository = repository;
    }

    public ContentEntity[] listContents() throws ContentIOException {
        if (this.contentItem == null) {
            return new ContentEntity[0];
        }
        return new ContentEntity[]{this.contentItem};
    }

    public ContentEntity getEntry(String name) throws ContentIOException {
        if (this.contentItem == null) {
            throw new ContentIOException("No such item");
        }
        if (this.contentItem.getName().equals(name)) {
            return this.contentItem;
        }
        throw new ContentIOException("No such item");
    }

    public ContentItem createItem(String name) throws ContentCreationException {
        if (this.contentItem == null) {
            this.contentItem = new StreamContentItem(name, this, this.repository.getInputStream(), this.repository.getOutputStream());
            return this.contentItem;
        }
        throw new ContentCreationException("Failed to create the item. Item already there");
    }

    public ContentLocation createLocation(String name) throws ContentCreationException {
        throw new ContentCreationException("Failed to create the item. Item already there");
    }

    public boolean exists(String name) {
        if (this.contentItem == null) {
            return false;
        }
        return this.contentItem.getName().equals(name);
    }

    public String getName() {
        return "root";
    }

    public Object getContentId() {
        return this.getName();
    }

    public Object getAttribute(String domain, String key) {
        return null;
    }

    public boolean setAttribute(String domain, String key, Object value) {
        return false;
    }

    public ContentLocation getParent() {
        return null;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public boolean delete() {
        return false;
    }
}

