/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.repository.zipwriter;

import java.io.IOException;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import org.jfree.repository.ContentCreationException;
import org.jfree.repository.ContentEntity;
import org.jfree.repository.ContentIOException;
import org.jfree.repository.ContentItem;
import org.jfree.repository.ContentLocation;
import org.jfree.repository.Repository;
import org.jfree.repository.RepositoryUtilities;
import org.jfree.repository.zipwriter.ZipContentItem;
import org.jfree.repository.zipwriter.ZipRepository;

public class ZipContentLocation
implements ContentLocation {
    private HashMap entries;
    private String name;
    private String contentId;
    private ContentLocation parent;
    private ZipRepository repository;

    public ZipContentLocation(ZipRepository repository, ContentLocation parent, String name) {
        this.repository = repository;
        this.parent = parent;
        this.name = name;
        this.entries = new HashMap();
        this.contentId = RepositoryUtilities.buildName(this, "/") + "/";
    }

    public ContentEntity[] listContents() throws ContentIOException {
        return this.entries.values().toArray(new ContentEntity[this.entries.size()]);
    }

    public ContentEntity getEntry(String name) throws ContentIOException {
        return (ContentEntity)this.entries.get(name);
    }

    public ContentItem createItem(String name) throws ContentCreationException {
        if (this.entries.containsKey(name)) {
            throw new ContentCreationException("Entry already exists");
        }
        ZipContentItem item = new ZipContentItem(name, this.repository, this);
        this.entries.put(name, item);
        return item;
    }

    public ContentLocation createLocation(String name) throws ContentCreationException {
        if (this.entries.containsKey(name)) {
            throw new ContentCreationException("Entry already exists");
        }
        ZipContentLocation item = new ZipContentLocation(this.repository, this, name);
        this.entries.put(name, item);
        try {
            ZipEntry entry = new ZipEntry(this.contentId);
            this.repository.writeDirectory(entry);
            return item;
        }
        catch (IOException e) {
            throw new ContentCreationException("Failed to create directory.");
        }
    }

    public boolean exists(String name) {
        return this.entries.containsKey(name);
    }

    public String getName() {
        return this.name;
    }

    public Object getContentId() {
        return this.contentId;
    }

    public Object getAttribute(String domain, String key) {
        return null;
    }

    public boolean setAttribute(String domain, String key, Object value) {
        return false;
    }

    public ContentLocation getParent() {
        return this.parent;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public boolean delete() {
        return false;
    }
}

