/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.repository.zipwriter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jfree.io.IOUtils;
import org.jfree.repository.ContentIOException;
import org.jfree.repository.ContentLocation;
import org.jfree.repository.DefaultMimeRegistry;
import org.jfree.repository.MimeRegistry;
import org.jfree.repository.Repository;
import org.jfree.repository.zipwriter.ZipContentLocation;
import org.jfree.repository.zipwriter.ZipEntryOutputStream;

public class ZipRepository
implements Repository {
    private ZipOutputStream zipOutputStream;
    private ZipEntryOutputStream currentStream;
    private MimeRegistry mimeRegistry;
    private ZipContentLocation root;

    public ZipRepository(OutputStream out, int level, MimeRegistry mimeRegistry) {
        this.mimeRegistry = mimeRegistry;
        this.zipOutputStream = new ZipOutputStream(out);
        this.zipOutputStream.setLevel(level);
        this.root = new ZipContentLocation(this, null, "");
    }

    public ZipRepository(OutputStream out, int level) {
        this(out, level, new DefaultMimeRegistry());
    }

    public ZipRepository(OutputStream out) {
        this(out, -1, new DefaultMimeRegistry());
    }

    public ContentLocation getRoot() throws ContentIOException {
        return this.root;
    }

    public MimeRegistry getMimeRegistry() {
        return this.mimeRegistry;
    }

    public void close() throws IOException {
        this.zipOutputStream.flush();
    }

    public void writeDirectory(ZipEntry entry) throws IOException {
        this.zipOutputStream.putNextEntry(entry);
    }

    public void writeContent(ZipEntry entry, InputStream in) throws IOException {
        this.zipOutputStream.putNextEntry(entry);
        IOUtils.getInstance().copyStreams(in, (OutputStream)this.zipOutputStream);
        this.zipOutputStream.closeEntry();
    }
}

