/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.BaseTable;
import org.hsqldb.CachedDataRow;
import org.hsqldb.CachedRow;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.DatabaseURL;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.NumberSequence;
import org.hsqldb.Parser;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.TriggerDef;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.store.BaseHashMap;
import org.hsqldb.store.ValuePool;

public class Table
extends BaseTable {
    public static final int SYSTEM_TABLE = 0;
    public static final int SYSTEM_SUBQUERY = 1;
    public static final int TEMP_TABLE = 2;
    public static final int MEMORY_TABLE = 3;
    public static final int CACHED_TABLE = 4;
    public static final int TEMP_TEXT_TABLE = 5;
    public static final int TEXT_TABLE = 6;
    public static final int VIEW = 7;
    static final int SYSTEM_VIEW = 8;
    public HashMappedList columnList;
    private int[] primaryKeyCols;
    private int[] primaryKeyTypes;
    private int[] primaryKeyColsSequence;
    int[] bestRowIdentifierCols;
    boolean bestRowIdentifierStrict;
    int[] bestIndexForColumn;
    Index bestIndex;
    int identityColumn;
    NumberSequence identitySequence;
    NumberSequence rowIdSequence;
    Constraint[] constraintList;
    HsqlArrayList[] triggerLists;
    private int[] colTypes;
    private int[] colSizes;
    private int[] colScales;
    private boolean[] colNullable;
    private Expression[] colDefaults;
    private int[] defaultColumnMap;
    private boolean hasDefaultValues;
    boolean sqlEnforceSize;
    protected int columnCount;
    public Database database;
    protected DataFileCache cache;
    protected HsqlNameManager.HsqlName tableName;
    private int tableType;
    protected boolean isReadOnly;
    protected boolean isTemp;
    protected boolean isCached;
    protected boolean isText;
    protected boolean isMemory;
    private boolean isView;
    protected boolean isLogged;
    protected int indexType;
    protected boolean onCommitPreserve;
    PersistentStore rowStore;
    Index[] indexList;
    HashSet constraintPath;
    HashMappedList tableUpdateList;

    Table(Database database, HsqlNameManager.HsqlName hsqlName, int n) throws HsqlException {
        this.database = database;
        this.sqlEnforceSize = database.sqlEnforceStrictSize;
        this.identitySequence = new NumberSequence(null, 0L, 1L, -5);
        this.rowIdSequence = new NumberSequence(null, 0L, 1L, -5);
        switch (n) {
            case 1: {
                this.isTemp = true;
                this.isMemory = true;
            }
            case 0: {
                this.isMemory = true;
                break;
            }
            case 4: {
                if (DatabaseURL.isFileBasedDatabaseType(database.getType())) {
                    this.cache = database.logger.getCache();
                    this.isCached = true;
                    this.isLogged = !this.database.isFilesReadOnly();
                    this.indexType = 1;
                    this.rowStore = new RowStore();
                    break;
                }
                n = 3;
            }
            case 3: {
                this.isMemory = true;
                this.isLogged = !this.database.isFilesReadOnly();
                break;
            }
            case 2: {
                this.isMemory = true;
                this.isTemp = true;
                break;
            }
            case 5: {
                if (!DatabaseURL.isFileBasedDatabaseType(database.getType())) {
                    throw Trace.error(63);
                }
                this.isTemp = true;
                this.isText = true;
                this.isReadOnly = true;
                this.indexType = 2;
                this.rowStore = new RowStore();
                break;
            }
            case 6: {
                if (!DatabaseURL.isFileBasedDatabaseType(database.getType())) {
                    throw Trace.error(63);
                }
                this.isText = true;
                this.indexType = 2;
                this.rowStore = new RowStore();
                break;
            }
            case 7: 
            case 8: {
                this.isView = true;
            }
        }
        this.tableType = n;
        this.tableName = hsqlName;
        this.primaryKeyCols = null;
        this.primaryKeyTypes = null;
        this.identityColumn = -1;
        this.columnList = new HashMappedList();
        this.indexList = new Index[0];
        this.constraintList = new Constraint[0];
        this.triggerLists = new HsqlArrayList[12];
        if (database.isFilesReadOnly() && this.isFileBased()) {
            this.isReadOnly = true;
        }
    }

    boolean equals(Session session, String string) {
        return this.tableName.name.equals(string);
    }

    boolean equals(String string) {
        return this.tableName.name.equals(string);
    }

    boolean equals(HsqlNameManager.HsqlName hsqlName) {
        return this.tableName.equals(hsqlName);
    }

    public final boolean isText() {
        return this.isText;
    }

    public final boolean isTemp() {
        return this.isTemp;
    }

    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    final boolean isView() {
        return this.isView;
    }

    final int getIndexType() {
        return this.indexType;
    }

    public final int getTableType() {
        return this.tableType;
    }

    public final boolean isDataReadOnly() {
        return this.isReadOnly;
    }

    void checkDataReadOnly() throws HsqlException {
        if (this.isReadOnly) {
            throw Trace.error(32);
        }
    }

    void setDataReadOnly(boolean bl) throws HsqlException {
        if (!bl && this.database.isFilesReadOnly() && this.isFileBased()) {
            throw Trace.error(32);
        }
        this.isReadOnly = bl;
    }

    boolean isFileBased() {
        return this.isCached || this.isText;
    }

    protected void setDataSource(Session session, String string, boolean bl, boolean bl2) throws HsqlException {
        throw Trace.error(22);
    }

    protected String getDataSource() {
        return null;
    }

    protected boolean isDescDataSource() {
        return false;
    }

    public void setHeader(String string) throws HsqlException {
        throw Trace.error(150);
    }

    public String getHeader() {
        return null;
    }

    void addConstraint(Constraint constraint) {
        this.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.constraintList, constraint, this.constraintList.length, 1);
    }

    void addPKConstraint(Constraint constraint) {
        this.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.constraintList, constraint, 0, 1);
    }

    Constraint[] getConstraints() {
        return this.constraintList;
    }

    Constraint getPrimaryConstraint() {
        return this.primaryKeyCols.length == 0 ? null : this.constraintList[0];
    }

    Index getUniqueConstraintIndexForColumns(int[] nArray) {
        if (ArrayUtil.areEqual(this.getPrimaryIndex().getColumns(), nArray, nArray.length, true)) {
            return this.getPrimaryIndex();
        }
        for (Constraint constraint : this.constraintList) {
            if (constraint.getType() != 2 || !ArrayUtil.areEqual(constraint.getMainColumns(), nArray, nArray.length, true)) continue;
            return constraint.getMainIndex();
        }
        return null;
    }

    Constraint getConstraintForColumns(Table table, int[] nArray, int[] nArray2) {
        for (Constraint constraint : this.constraintList) {
            if (!constraint.isEquivalent(table, nArray, this, nArray2)) continue;
            return constraint;
        }
        return null;
    }

    Constraint getUniqueConstraintForColumns(int[] nArray) {
        for (Constraint constraint : this.constraintList) {
            if (!constraint.isEquivalent(nArray, 2)) continue;
            return constraint;
        }
        return null;
    }

    Constraint getUniqueOrPKConstraintForIndex(Index index) {
        for (Constraint constraint : this.constraintList) {
            if (constraint.getMainIndex() != index || constraint.getType() != 2 && constraint.getType() != 4) continue;
            return constraint;
        }
        return null;
    }

    int getNextConstraintIndex(int n, int n2) {
        int n3 = this.constraintList.length;
        for (int i = n; i < n3; ++i) {
            Constraint constraint = this.constraintList[i];
            if (constraint.getType() != n2) continue;
            return i;
        }
        return -1;
    }

    void addColumn(Column column) throws HsqlException {
        if (this.findColumn(column.columnName.name) >= 0) {
            throw Trace.error(27, column.columnName.name);
        }
        if (column.isIdentity()) {
            Trace.check(column.getType() == 4 || column.getType() == -5, 16, column.columnName.name);
            Trace.check(this.identityColumn == -1, 24, column.columnName.name);
            this.identityColumn = this.columnCount;
        }
        if (this.primaryKeyCols != null) {
            Trace.doAssert(false, "Table.addColumn");
        }
        this.columnList.add(column.columnName.name, column);
        ++this.columnCount;
    }

    void addColumns(Result.ResultMetaData resultMetaData, int n) throws HsqlException {
        for (int i = 0; i < n; ++i) {
            Column column = new Column(this.database.nameManager.newHsqlName(resultMetaData.colLabels[i], resultMetaData.isLabelQuoted[i]), true, resultMetaData.colTypes[i], resultMetaData.colSizes[i], resultMetaData.colScales[i], false, null);
            this.addColumn(column);
        }
    }

    void addColumns(Select select) throws HsqlException {
        int n = select.iResultLen;
        for (int i = 0; i < n; ++i) {
            Expression expression = select.exprColumns[i];
            Column column = new Column(this.database.nameManager.newHsqlName(expression.getAlias(), expression.isAliasQuoted()), true, expression.getDataType(), expression.getColumnSize(), expression.getColumnScale(), false, null);
            this.addColumn(column);
        }
    }

    public HsqlNameManager.HsqlName getName() {
        return this.tableName;
    }

    public int getId() {
        return this.tableName.hashCode();
    }

    void rename(Session session, String string, boolean bl) throws HsqlException {
        String string2 = this.tableName.name;
        this.tableName.rename(string, bl);
        if (HsqlNameManager.HsqlName.isReservedIndexName(this.getPrimaryIndex().getName().name)) {
            this.getPrimaryIndex().getName().rename("SYS_PK", string, bl);
        }
        this.renameTableInCheckConstraints(session, string2, string);
    }

    int getInternalColumnCount() {
        return this.columnCount;
    }

    protected Table duplicate() throws HsqlException {
        Table table = new Table(this.database, this.tableName, this.tableType);
        return table;
    }

    void checkColumnsMatch(int[] nArray, Table table, int[] nArray2) throws HsqlException {
        if (nArray.length != nArray2.length) {
            throw Trace.error(5);
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= this.columnCount || nArray2[i] >= table.columnCount) {
                throw Trace.error(5);
            }
            if (this.getColumn(nArray[i]).getType() == table.getColumn(nArray2[i]).getType()) continue;
            throw Trace.error(57);
        }
    }

    Table moveDefinition(int[] nArray, Column column, int n, int n2) throws HsqlException {
        Object object;
        int[] nArray2;
        Table table = this.duplicate();
        for (int i = 0; i < this.columnCount + 1; ++i) {
            if (i == n) {
                if (n2 == 0) {
                    if (column != null) {
                        table.addColumn(column);
                        continue;
                    }
                } else if (n2 > 0) {
                    table.addColumn(column);
                } else if (n2 < 0) continue;
            }
            if (i == this.columnCount) break;
            table.addColumn(this.getColumn(i));
        }
        int[] nArray3 = nArray2 = this.primaryKeyCols.length == 0 ? null : this.primaryKeyCols;
        if (nArray2 != null) {
            object = ArrayUtil.toAdjustedColumnArray(nArray2, n, n2);
            if (nArray2.length != ((int[])object).length) {
                throw Trace.error(25);
            }
            nArray2 = object;
        }
        table.createPrimaryKey(this.getIndex(0).getName(), nArray2, false);
        table.constraintList = this.constraintList;
        object = null;
        if (nArray != null) {
            object = this.getIndex(nArray, n);
        }
        if (object != null) {
            if (object.isConstraint()) {
                throw Trace.error(252);
            }
            throw Trace.error(123);
        }
        for (int i = 1; i < this.indexList.length; ++i) {
            if (nArray != null && ArrayUtil.find(nArray, i) != -1) continue;
            table.createAdjustedIndex(this.indexList[i], n, n2);
        }
        table.triggerLists = this.triggerLists;
        return table;
    }

    Index getIndex(int[] nArray, int n) {
        for (int i = 1; i < this.indexList.length; ++i) {
            Index index;
            int[] nArray2;
            if (nArray != null && ArrayUtil.find(nArray, i) != -1 || ArrayUtil.find(nArray2 = (index = this.indexList[i]).getColumns(), n) == -1) continue;
            return index;
        }
        return null;
    }

    private void copyIndexes(Table table, int n, int n2, int n3) throws HsqlException {
        for (int i = 1; i < this.getIndexCount(); ++i) {
            Index index;
            Index index2 = this.indexList[i];
            if (n == i || (index = table.createAdjustedIndex(index2, n2, n3)) != null) continue;
            throw Trace.error(123);
        }
    }

    Table moveDefinitionPK(int[] nArray, boolean bl) throws HsqlException {
        int n;
        if (this.hasPrimaryKey() && nArray != null || !this.hasPrimaryKey() && nArray == null) {
            throw Trace.error(25);
        }
        Table table = this.duplicate();
        for (n = 0; n < this.columnCount; ++n) {
            table.addColumn(this.getColumn(n).duplicate(bl));
        }
        table.createPrimaryKey(this.getIndex(0).getName(), nArray, true);
        table.constraintList = this.constraintList;
        for (n = 1; n < this.getIndexCount(); ++n) {
            Index index = this.getIndex(n);
            table.createAdjustedIndex(index, -1, 0);
        }
        table.triggerLists = this.triggerLists;
        return table;
    }

    void updateConstraintsTables(Session session, Table table, int n, int n2) throws HsqlException {
        for (Constraint constraint : this.constraintList) {
            constraint.replaceTable(table, this, n, n2);
            if (constraint.constType != 3) continue;
            this.recompileCheckConstraint(session, constraint);
        }
    }

    private void recompileCheckConstraints(Session session) throws HsqlException {
        for (Constraint constraint : this.constraintList) {
            if (constraint.constType != 3) continue;
            this.recompileCheckConstraint(session, constraint);
        }
    }

    private void recompileCheckConstraint(Session session, Constraint constraint) throws HsqlException {
        Expression expression;
        String string = constraint.core.check.getDDL();
        Tokenizer tokenizer = new Tokenizer(string);
        Parser parser = new Parser(session, this.database, tokenizer);
        constraint.core.check = expression = parser.parseExpression();
        expression.setLikeOptimised();
        Select select = Expression.getCheckSelect(session, this, expression);
        constraint.core.checkFilter = select.tFilter[0];
        constraint.core.checkFilter.setAsCheckFilter();
        constraint.core.mainTable = this;
    }

    void checkColumnInCheckConstraint(String string) throws HsqlException {
        for (Constraint constraint : this.constraintList) {
            if (constraint.constType != 3 || !constraint.hasColumn(this, string)) continue;
            throw Trace.error(197, constraint.getName());
        }
    }

    void checkColumnInFKConstraint(int n) throws HsqlException {
        for (Constraint constraint : this.constraintList) {
            if (!constraint.hasColumn(n) || constraint.getType() != 1 && constraint.getType() != 0) continue;
            throw Trace.error(197, constraint.getName().name);
        }
    }

    void checkColumnInFKConstraint(int n, int n2) throws HsqlException {
        for (Constraint constraint : this.constraintList) {
            if (!constraint.hasColumn(n) || constraint.getType() != 0 || n2 != constraint.getUpdateAction() && n2 != constraint.getDeleteAction()) continue;
            throw Trace.error(197, constraint.getName().name);
        }
    }

    private void renameColumnInCheckConstraints(String string, String string2, boolean bl) throws HsqlException {
        for (Constraint constraint : this.constraintList) {
            if (constraint.constType != 3) continue;
            Expression.Collector collector = new Expression.Collector();
            collector.addAll(constraint.core.check, 2);
            Iterator iterator = collector.iterator();
            while (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                if (expression.getColumnName() != string) continue;
                expression.setColumnName(string2, bl);
            }
        }
    }

    private void renameTableInCheckConstraints(Session session, String string, String string2) throws HsqlException {
        for (Constraint constraint : this.constraintList) {
            if (constraint.constType != 3) continue;
            Expression.Collector collector = new Expression.Collector();
            collector.addAll(constraint.core.check, 2);
            Iterator iterator = collector.iterator();
            while (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                if (expression.getTableName() != string) continue;
                expression.setTableName(string2);
            }
        }
        this.recompileCheckConstraints(session);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getIndexCount() {
        return this.indexList.length;
    }

    int getIdentityColumn() {
        return this.identityColumn;
    }

    int getColumnNr(String string) throws HsqlException {
        int n = this.findColumn(string);
        if (n == -1) {
            throw Trace.error(28, string);
        }
        return n;
    }

    int findColumn(String string) {
        int n = this.columnList.getIndex(string);
        return n;
    }

    public Index getPrimaryIndex() {
        return this.getIndex(0);
    }

    public int[] getPrimaryKey() {
        return this.primaryKeyCols;
    }

    public int[] getPrimaryKeyTypes() {
        return this.primaryKeyTypes;
    }

    public boolean hasPrimaryKey() {
        return this.primaryKeyCols.length != 0;
    }

    int[] getBestRowIdentifiers() {
        return this.bestRowIdentifierCols;
    }

    boolean isBestRowIdentifiersStrict() {
        return this.bestRowIdentifierStrict;
    }

    void setBestRowIdentifiers() {
        int[] nArray = null;
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        if (this.colNullable == null) {
            return;
        }
        this.bestIndex = null;
        this.bestIndexForColumn = new int[this.columnList.size()];
        ArrayUtil.fillArray(this.bestIndexForColumn, -1);
        for (int i = 0; i < this.indexList.length; ++i) {
            Index index = this.indexList[i];
            int[] nArray2 = index.getColumns();
            int n3 = index.getVisibleColumns();
            if (i == 0) {
                if (!this.hasPrimaryKey()) continue;
                bl = true;
            }
            if (this.bestIndexForColumn[nArray2[0]] == -1) {
                this.bestIndexForColumn[nArray2[0]] = i;
            }
            if (!index.isUnique()) {
                if (this.bestIndex != null) continue;
                this.bestIndex = index;
                continue;
            }
            int n4 = 0;
            for (int j = 0; j < n3; ++j) {
                if (this.colNullable[nArray2[j]]) continue;
                ++n4;
            }
            if (this.bestIndex != null) {
                this.bestIndex = index;
            }
            if (n4 == n3) {
                if (nArray != null && n == n2 && n3 >= n) continue;
                nArray = nArray2;
                n = n3;
                n2 = n3;
                bl = true;
                continue;
            }
            if (bl || nArray != null && n3 >= n && n4 <= n2) continue;
            nArray = nArray2;
            n = n3;
            n2 = n4;
        }
        this.bestRowIdentifierCols = nArray == null || n == nArray.length ? nArray : ArrayUtil.arraySlice(nArray, 0, n);
        this.bestRowIdentifierStrict = bl;
        if (this.hasPrimaryKey()) {
            this.bestIndex = this.getPrimaryIndex();
        }
    }

    void setDefaultExpression(int n, Expression expression) {
        Column column = this.getColumn(n);
        column.setDefaultExpression(expression);
        this.colDefaults[n] = column.getDefaultExpression();
        this.resetDefaultsFlag();
    }

    void resetDefaultsFlag() {
        this.hasDefaultValues = false;
        for (int i = 0; i < this.columnCount; ++i) {
            this.hasDefaultValues = this.hasDefaultValues || this.colDefaults[i] != null;
        }
    }

    DataFileCache getCache() {
        return this.cache;
    }

    Index getIndexForColumn(Session session, int n) {
        int n2 = this.bestIndexForColumn[n];
        if (n2 == -1 && (this.tableType == 1 || this.tableType == 0)) {
            try {
                HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newAutoName("IDX");
                this.createIndex(session, new int[]{n}, hsqlName, false, false, false);
                n2 = this.bestIndexForColumn[n];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2 == -1 ? null : this.getIndex(n2);
    }

    Index getIndexForColumns(boolean[] blArray) {
        Index index = null;
        int n = 0;
        for (int i = 0; i < this.indexList.length; ++i) {
            Index index2 = this.indexList[i];
            boolean bl = ArrayUtil.containsAllTrueElements(blArray, index2.colCheck);
            if (!bl || index2.getVisibleColumns() <= n) continue;
            n = index2.getVisibleColumns();
            index = index2;
        }
        return index;
    }

    Index getIndexForColumns(int[] nArray, boolean bl) throws HsqlException {
        int n = this.getIndexCount();
        for (int i = 0; i < n; ++i) {
            Index index = this.getIndex(i);
            int[] nArray2 = index.getColumns();
            if (!ArrayUtil.haveEqualArrays(nArray2, nArray, nArray.length) || bl && !index.isUnique()) continue;
            return index;
        }
        return null;
    }

    public int[] getIndexRootsArray() {
        int[] nArray = new int[this.getIndexCount()];
        for (int i = 0; i < this.getIndexCount(); ++i) {
            nArray[i] = this.indexList[i].getRoot();
        }
        return nArray;
    }

    String getIndexRoots() {
        String string = StringUtil.getList(this.getIndexRootsArray(), " ", "");
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(' ');
        stringBuffer.append(this.identitySequence.peek());
        return stringBuffer.toString();
    }

    public void setIndexRoots(int[] nArray) throws HsqlException {
        Trace.check(this.isCached, 22);
        for (int i = 0; i < this.getIndexCount(); ++i) {
            int n = nArray[i];
            CachedRow cachedRow = null;
            if (n != -1) {
                cachedRow = (CachedRow)this.rowStore.get(n);
            }
            Node node = null;
            if (cachedRow != null) {
                node = cachedRow.getNode(i);
            }
            this.indexList[i].setRoot(null, node);
        }
    }

    void setIndexRoots(String string) throws HsqlException {
        Trace.check(this.isCached, 22);
        Tokenizer tokenizer = new Tokenizer(string);
        int[] nArray = new int[this.getIndexCount()];
        for (int i = 0; i < this.getIndexCount(); ++i) {
            int n;
            nArray[i] = n = tokenizer.getInt();
        }
        this.setIndexRoots(nArray);
        long l = tokenizer.getBigint();
        this.identitySequence.reset(l);
    }

    void createPrimaryKey(int[] nArray) throws HsqlException {
        this.createPrimaryKey(null, nArray, false);
    }

    void createPrimaryKey() throws HsqlException {
        this.createPrimaryKey(null, null, false);
    }

    void createPrimaryKey(HsqlNameManager.HsqlName hsqlName, int[] nArray, boolean bl) throws HsqlException {
        int n;
        if (this.primaryKeyCols != null) {
            Trace.doAssert(false, "Table.createPrimaryKey(column)");
        }
        if (nArray == null) {
            nArray = new int[]{};
        } else {
            for (n = 0; n < nArray.length; ++n) {
                if (bl) {
                    this.getColumn(nArray[n]).setNullable(false);
                }
                this.getColumn(nArray[n]).setPrimaryKey(true);
            }
        }
        this.primaryKeyCols = nArray;
        this.colTypes = new int[this.columnCount];
        this.colDefaults = new Expression[this.columnCount];
        this.colSizes = new int[this.columnCount];
        this.colScales = new int[this.columnCount];
        this.colNullable = new boolean[this.columnCount];
        this.defaultColumnMap = new int[this.columnCount];
        for (n = 0; n < this.columnCount; ++n) {
            this.setColumnTypeVars(n);
        }
        this.primaryKeyTypes = new int[this.primaryKeyCols.length];
        ArrayUtil.copyColumnValues(this.colTypes, this.primaryKeyCols, this.primaryKeyTypes);
        this.primaryKeyColsSequence = new int[this.primaryKeyCols.length];
        ArrayUtil.fillSequence(this.primaryKeyColsSequence);
        this.resetDefaultsFlag();
        HsqlNameManager.HsqlName hsqlName2 = hsqlName != null ? hsqlName : this.database.nameManager.newAutoName("IDX");
        this.createPrimaryIndex(nArray, hsqlName2);
        this.setBestRowIdentifiers();
    }

    void setColumnTypeVars(int n) {
        Column column = this.getColumn(n);
        this.colTypes[n] = column.getType();
        this.colSizes[n] = column.getSize();
        this.colScales[n] = column.getScale();
        this.colNullable[n] = column.isNullable();
        this.defaultColumnMap[n] = n;
        if (column.isIdentity()) {
            this.identitySequence.reset(column.identityStart, column.identityIncrement);
        }
        this.colDefaults[n] = column.getDefaultExpression();
    }

    HsqlNameManager.HsqlName makeSysPKName() throws HsqlException {
        return this.database.nameManager.newAutoName("PK");
    }

    void createPrimaryIndex(int[] nArray, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.colTypes[nArray[i]];
        }
        Index index = new Index(this.database, hsqlName, this, nArray, nArray2, true, true, true, false, nArray, nArray2, this.isTemp);
        this.addIndex(index);
    }

    private Index createAdjustedIndex(Index index, int n, int n2) throws HsqlException {
        int[] nArray = (int[])ArrayUtil.resizeArray(index.getColumns(), index.getVisibleColumns());
        int[] nArray2 = ArrayUtil.toAdjustedColumnArray(nArray, n, n2);
        if (nArray2.length != index.getVisibleColumns()) {
            return null;
        }
        return this.createIndexStructure(nArray2, index.getName(), index.isUnique(), index.isConstraint, index.isForward);
    }

    Index createIndex(Session session, int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2, boolean bl3) throws HsqlException {
        int n = this.createIndexStructureGetNo(nArray, hsqlName, bl, bl2, bl3);
        Index index = this.indexList[n];
        Index index2 = this.getPrimaryIndex();
        RowIterator rowIterator = index2.firstRow(session);
        int n2 = 0;
        HsqlException hsqlException = null;
        try {
            while (rowIterator.hasNext()) {
                Row row = rowIterator.next();
                Node node = row.getNode(n - 1);
                Node node2 = Node.newNode(row, n, this);
                node2.nNext = node.nNext;
                node.nNext = node2;
                ++n2;
                index.insert(session, row, n);
            }
            return index;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            hsqlException = Trace.error(72);
        }
        catch (HsqlException hsqlException2) {
            hsqlException = Trace.error(9, new Object[]{index.getName().statementName, index.getColumnNameList()});
        }
        rowIterator = index2.firstRow(session);
        for (int i = 0; i < n2; ++i) {
            Row row = rowIterator.next();
            Node node = row.getNode(0);
            int n3 = n;
            while (--n3 > 0) {
                node = node.nNext;
            }
            node.nNext = node.nNext.nNext;
        }
        this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, n, -1);
        this.setBestRowIdentifiers();
        throw hsqlException;
    }

    Index createIndexStructure(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2, boolean bl3) throws HsqlException {
        int n = this.createIndexStructureGetNo(nArray, hsqlName, bl, bl2, bl3);
        return this.indexList[n];
    }

    int createIndexStructureGetNo(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2, boolean bl3) throws HsqlException {
        if (this.primaryKeyCols == null) {
            Trace.doAssert(false, "createIndex");
        }
        int n = nArray.length;
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[i];
            nArray3[i] = this.colTypes[nArray2[i]];
        }
        int[] nArray4 = this.getPrimaryKey();
        int[] nArray5 = this.getPrimaryKeyTypes();
        Index index = new Index(this.database, hsqlName, this, nArray2, nArray3, false, bl, bl2, bl3, nArray4, nArray5, this.isTemp);
        int n2 = this.addIndex(index);
        this.setBestRowIdentifiers();
        return n2;
    }

    private int addIndex(Index index) {
        int n;
        for (n = 0; n < this.indexList.length; ++n) {
            Index index2 = this.indexList[n];
            int n2 = index.getIndexOrderValue() - index2.getIndexOrderValue();
            if (n2 < 0) break;
        }
        this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, index, n, 1);
        return n;
    }

    boolean isIndexingMutable() {
        return !this.isIndexCached();
    }

    void checkDropIndex(String string, HashSet hashSet, boolean bl) throws HsqlException {
        Index index = this.getIndex(string);
        if (index == null) {
            throw Trace.error(26, string);
        }
        if (!bl && index.equals(this.getIndex(0))) {
            throw Trace.error(25, string);
        }
        for (Constraint constraint : this.constraintList) {
            if (hashSet != null && hashSet.contains(constraint)) continue;
            if (constraint.isIndexFK(index)) {
                throw Trace.error(50, string);
            }
            if (!constraint.isIndexUnique(index)) continue;
            throw Trace.error(56, string);
        }
    }

    public boolean isEmpty(Session session) {
        if (this.getIndexCount() == 0) {
            return true;
        }
        return this.getIndex(0).isEmpty(session);
    }

    int[] getColumnMap() {
        return this.defaultColumnMap;
    }

    int[] getNewColumnMap() {
        return new int[this.columnCount];
    }

    boolean[] getNewColumnCheckList() {
        return new boolean[this.columnCount];
    }

    public Object[] getEmptyRowData() {
        return new Object[this.columnCount];
    }

    Object[] getNewRowData(Session session, boolean[] blArray) throws HsqlException {
        Object[] objectArray = new Object[this.columnCount];
        if (blArray != null && this.hasDefaultValues) {
            for (int i = 0; i < this.columnCount; ++i) {
                Expression expression = this.colDefaults[i];
                if (blArray[i] || expression == null) continue;
                objectArray[i] = expression.getValue(session, this.colTypes[i]);
            }
        }
        return objectArray;
    }

    void dropIndex(Session session, String string) throws HsqlException {
        int n = this.getIndexIndex(string);
        this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, n, -1);
        this.setBestRowIdentifiers();
        this.dropIndexFromRows(session, n);
    }

    void dropIndexFromRows(Session session, int n) throws HsqlException {
        RowIterator rowIterator = this.getPrimaryIndex().firstRow(session);
        while (rowIterator.hasNext()) {
            Row row = rowIterator.next();
            int n2 = n - 1;
            Node node = row.getNode(0);
            while (n2-- > 0) {
                node = node.nNext;
            }
            node.nNext = node.nNext.nNext;
        }
    }

    void moveData(Session session, Table table, int n, int n2) throws HsqlException {
        Object object = null;
        Column column = null;
        if (n2 >= 0 && n != -1) {
            column = this.getColumn(n);
            object = column.getDefaultValue(session);
        }
        RowIterator rowIterator = table.getPrimaryIndex().firstRow(session);
        while (rowIterator.hasNext()) {
            Row row = rowIterator.next();
            Object[] objectArray = row.getData();
            Object[] objectArray2 = this.getEmptyRowData();
            if (n2 == 0 && n != -1) {
                object = Column.convertObject(session, objectArray[n], column.getType(), column.getSize(), column.getScale());
            }
            ArrayUtil.copyAdjustArray(objectArray, objectArray2, object, n, n2);
            this.setIdentityColumn(session, objectArray2);
            this.enforceNullConstraints(objectArray2);
            Row row2 = this.newRow(objectArray2);
            this.indexRow(session, row2);
        }
        table.drop();
    }

    int insert(Session session, Result result) throws HsqlException {
        Record record = result.rRoot;
        int n = 0;
        this.fireAll(session, 3);
        while (record != null) {
            this.insertRow(session, record.data);
            record = record.next;
            ++n;
        }
        this.fireAll(session, 0);
        return n;
    }

    void insert(Session session, Object[] objectArray) throws HsqlException {
        this.fireAll(session, 3);
        this.insertRow(session, objectArray);
        this.fireAll(session, 0);
    }

    private void insertRow(Session session, Object[] objectArray) throws HsqlException {
        if (this.triggerLists[9] != null) {
            this.fireAll(session, 9, null, objectArray);
        }
        this.setIdentityColumn(session, objectArray);
        this.checkRowDataInsert(session, objectArray);
        this.insertNoCheck(session, objectArray);
        if (this.triggerLists[6] != null) {
            this.fireAll(session, 6, null, objectArray);
            this.checkRowDataInsert(session, objectArray);
        }
    }

    void insertIntoTable(Session session, Result result) throws HsqlException {
        this.insertResult(session, result);
        if (!this.isLogged) {
            return;
        }
        Record record = result.rRoot;
        while (record != null) {
            this.database.logger.writeInsertStatement(session, this, record.data);
            record = record.next;
        }
    }

    private void insertNoCheck(Session session, Object[] objectArray) throws HsqlException {
        Row row = this.newRow(objectArray);
        this.indexRow(session, row);
        if (session != null) {
            session.addInsertAction(this, row);
        }
        if (this.isLogged) {
            this.database.logger.writeInsertStatement(session, this, objectArray);
        }
    }

    public void insertNoCheckFromLog(Session session, Object[] objectArray) throws HsqlException {
        Row row = this.newRow(objectArray);
        this.updateIdentityValue(objectArray);
        this.indexRow(session, row);
        if (session != null) {
            session.addInsertAction(this, row);
        }
    }

    void insertNoCheckRollback(Session session, Row row, boolean bl) throws HsqlException {
        Row row2 = this.restoreRow(row);
        this.indexRow(session, row2);
        if (bl && this.isLogged) {
            this.database.logger.writeInsertStatement(session, this, row.getData());
        }
    }

    int insertSys(Result result) throws HsqlException {
        Record record = result.rRoot;
        int n = 0;
        while (record != null) {
            this.insertData(null, record.data);
            record = record.next;
            ++n;
        }
        return n;
    }

    int insertResult(Session session, Result result) throws HsqlException {
        Record record = result.rRoot;
        int n = 0;
        while (record != null) {
            Object[] objectArray = (Object[])ArrayUtil.resizeArrayIfDifferent(record.data, this.columnCount);
            this.insertData(session, objectArray);
            record = record.next;
            ++n;
        }
        return n;
    }

    public void insertFromScript(Object[] objectArray) throws HsqlException {
        this.updateIdentityValue(objectArray);
        this.insertData(null, objectArray);
    }

    public void insertData(Session session, Object[] objectArray) throws HsqlException {
        Row row = this.newRow(objectArray);
        this.indexRow(session, row);
        this.commitRowToStore(row);
    }

    public void insertSys(Object[] objectArray) throws HsqlException {
        Row row = this.newRow(objectArray);
        this.indexRow(null, row);
    }

    protected void insertFromTextSource(CachedRow cachedRow) throws HsqlException {
        int n;
        Object[] objectArray = cachedRow.getData();
        this.updateIdentityValue(objectArray);
        this.enforceFieldValueLimits(objectArray, this.defaultColumnMap);
        this.enforceNullConstraints(objectArray);
        try {
            for (n = 0; n < this.indexList.length; ++n) {
                this.indexList[n].insert(null, cachedRow, n);
            }
        }
        catch (HsqlException hsqlException) {
            --n;
            while (n >= 0) {
                Node node = cachedRow.getNode(n);
                this.indexList[n].delete(null, node);
                --n;
            }
            cachedRow.delete();
            this.removeRowFromStore(cachedRow);
            throw hsqlException;
        }
    }

    protected void enforceNullConstraints(Object[] objectArray) throws HsqlException {
        for (int i = 0; i < this.columnCount; ++i) {
            if (objectArray[i] != null || this.colNullable[i]) continue;
            Trace.throwerror(10, "column: " + this.getColumn((int)i).columnName.name + " table: " + this.tableName.name);
        }
    }

    protected void setIdentityColumn(Session session, Object[] objectArray) throws HsqlException {
        if (this.identityColumn != -1) {
            Number number = (Number)objectArray[this.identityColumn];
            if (number == null) {
                number = this.colTypes[this.identityColumn] == 4 ? (Number)ValuePool.getInt((int)this.identitySequence.getValue()) : (Number)ValuePool.getLong(this.identitySequence.getValue());
                objectArray[this.identityColumn] = number;
            } else {
                this.identitySequence.getValue(number.longValue());
            }
            if (session != null) {
                session.setLastIdentity(number);
            }
        }
    }

    protected void updateIdentityValue(Object[] objectArray) throws HsqlException {
        Number number;
        if (this.identityColumn != -1 && (number = (Number)objectArray[this.identityColumn]) != null) {
            this.identitySequence.getValue(number.longValue());
        }
    }

    void enforceFieldValueLimits(Object[] objectArray, int[] nArray) throws HsqlException {
        if (this.sqlEnforceSize) {
            if (nArray == null) {
                nArray = this.defaultColumnMap;
            }
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (this.colTypes[n] != 93 && this.colSizes[n] == 0 || objectArray[n] == null) continue;
                objectArray[n] = Column.enforceSize(objectArray[n], this.colTypes[n], this.colSizes[n], this.colScales[n], true);
            }
        }
    }

    void fireAll(Session session, int n, Object[] objectArray, Object[] objectArray2) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        HsqlArrayList hsqlArrayList = this.triggerLists[n];
        if (hsqlArrayList == null) {
            return;
        }
        int n2 = hsqlArrayList.size();
        for (int i = 0; i < n2; ++i) {
            TriggerDef triggerDef = (TriggerDef)hsqlArrayList.get(i);
            triggerDef.pushPair(session, objectArray, objectArray2);
        }
    }

    void fireAll(Session session, int n) {
        if (this.triggerLists[n] != null) {
            this.fireAll(session, n, null, null);
        }
    }

    void addTrigger(TriggerDef triggerDef) {
        if (this.triggerLists[triggerDef.vectorIndex] == null) {
            this.triggerLists[triggerDef.vectorIndex] = new HsqlArrayList();
        }
        this.triggerLists[triggerDef.vectorIndex].add(triggerDef);
    }

    void dropTrigger(String string) {
        int n = 12;
        for (int i = 0; i < n; ++i) {
            HsqlArrayList hsqlArrayList = this.triggerLists[i];
            if (hsqlArrayList == null) continue;
            for (int j = hsqlArrayList.size() - 1; j >= 0; --j) {
                TriggerDef triggerDef = (TriggerDef)hsqlArrayList.get(j);
                if (!triggerDef.name.name.equals(string)) continue;
                hsqlArrayList.remove(j);
                triggerDef.terminate();
            }
            if (!hsqlArrayList.isEmpty()) continue;
            this.triggerLists[i] = null;
        }
    }

    void dropTriggers() {
        int n = 12;
        for (int i = 0; i < n; ++i) {
            HsqlArrayList hsqlArrayList = this.triggerLists[i];
            if (hsqlArrayList == null) continue;
            for (int j = hsqlArrayList.size() - 1; j >= 0; --j) {
                TriggerDef triggerDef = (TriggerDef)hsqlArrayList.get(j);
                triggerDef.terminate();
            }
            this.triggerLists[i] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkCascadeDelete(Session session, Table table, HashMappedList hashMappedList, Row row, boolean bl, HashSet hashSet) throws HsqlException {
        block5: for (Constraint constraint : table.constraintList) {
            RowIterator rowIterator;
            if (constraint.getType() != 1 || constraint.getRef() == null || !(rowIterator = constraint.findFkRef(session, row.getData(), bl)).hasNext()) continue;
            try {
                Row row2;
                boolean bl2;
                Object object;
                if (constraint.core.deleteAction == 3) {
                    if (constraint.core.mainTable == constraint.core.refTable && row.equals(object = rowIterator.next())) continue;
                    throw Trace.error(8, 100, new Object[]{constraint.core.fkName.name, constraint.core.refTable.getName().name});
                }
                object = constraint.getRef();
                boolean bl3 = bl2 = ((Table)object).getNextConstraintIndex(0, 1) != -1;
                if (!bl && !bl2) continue;
                Index index = constraint.getRefIndex();
                int[] nArray = constraint.getMainColumns();
                int[] nArray2 = constraint.getRefColumns();
                Object[] objectArray = row.getData();
                boolean bl4 = constraint.getDeleteAction() == 2 || constraint.getDeleteAction() == 4;
                HashMappedList hashMappedList2 = null;
                if (bl4 && (hashMappedList2 = (HashMappedList)hashMappedList.get(object)) == null) {
                    hashMappedList2 = new HashMappedList();
                    hashMappedList.add(object, hashMappedList2);
                }
                while ((row2 = rowIterator.next()) != null && !row2.isCascadeDeleted()) {
                    if (index.compareRowNonUnique(session, objectArray, nArray, row2.getData()) != 0) {
                        continue block5;
                    }
                    if (bl4) {
                        int n;
                        Object[] objectArray2 = ((Table)object).getEmptyRowData();
                        System.arraycopy(row2.getData(), 0, objectArray2, 0, objectArray2.length);
                        if (constraint.getDeleteAction() == 2) {
                            for (n = 0; n < nArray2.length; ++n) {
                                objectArray2[nArray2[n]] = null;
                            }
                        } else {
                            for (n = 0; n < nArray2.length; ++n) {
                                Column column = ((Table)object).getColumn(nArray2[n]);
                                objectArray2[nArray2[n]] = column.getDefaultValue(session);
                            }
                        }
                        if (bl2 && hashSet.add(constraint)) {
                            Table.checkCascadeUpdate(session, (Table)object, null, row2, objectArray2, nArray2, null, hashSet);
                            hashSet.remove(constraint);
                        }
                        if (bl && (object != table || !row2.equals(row))) {
                            Table.mergeUpdate(hashMappedList2, row2, objectArray2, nArray2);
                        }
                    } else if (bl2) {
                        if (object != table) {
                            if (hashSet.add(constraint)) {
                                Table.checkCascadeDelete(session, (Table)object, hashMappedList, row2, bl, hashSet);
                                hashSet.remove(constraint);
                            }
                        } else if (row2 != row) {
                            Table.checkCascadeDelete(session, (Table)object, hashMappedList, row2, bl, hashSet);
                        }
                    }
                    if (!bl || bl4 || row2.isCascadeDeleted()) continue;
                    super.deleteNoRefCheck(session, row2);
                }
            }
            finally {
                rowIterator.release();
            }
        }
    }

    static void checkCascadeUpdate(Session session, Table table, HashMappedList hashMappedList, Row row, Object[] objectArray, int[] nArray, Table table2, HashSet hashSet) throws HsqlException {
        for (Constraint constraint : table.constraintList) {
            RowIterator rowIterator;
            int[] nArray2;
            if (constraint.getType() == 0 && constraint.getRef() != null) {
                if (table2 != null && constraint.getMain() == table2 || ArrayUtil.countCommonElements(nArray, constraint.getRefColumns()) == 0) continue;
                constraint.hasMainRef(session, objectArray);
                continue;
            }
            if (constraint.getType() != 1 || constraint.getRef() == null || (nArray2 = ArrayUtil.commonElements(nArray, constraint.getMainColumns())) == null) continue;
            int[] nArray3 = constraint.getMainColumns();
            int[] nArray4 = constraint.getRefColumns();
            boolean bl = true;
            for (int i = 0; i < nArray3.length; ++i) {
                if (row.getData()[nArray3[i]].equals(objectArray[nArray3[i]])) continue;
                bl = false;
                break;
            }
            if (bl || !(rowIterator = constraint.findFkRef(session, row.getData(), false)).hasNext()) continue;
            if (constraint.core.updateAction == 3) {
                throw Trace.error(8, 100, new Object[]{constraint.core.fkName.name, constraint.core.refTable.getName().name});
            }
            Table table3 = constraint.getRef();
            boolean bl2 = table3.getNextConstraintIndex(0, 1) != -1;
            Index index = constraint.getRefIndex();
            HashMappedList hashMappedList2 = (HashMappedList)hashMappedList.get(table3);
            if (hashMappedList2 == null) {
                hashMappedList2 = new HashMappedList();
                hashMappedList.add(table3, hashMappedList2);
            }
            Row row2 = rowIterator.next();
            while (row2 != null && index.compareRowNonUnique(session, row.getData(), nArray3, row2.getData()) == 0) {
                int n;
                Object[] objectArray2 = table3.getEmptyRowData();
                System.arraycopy(row2.getData(), 0, objectArray2, 0, objectArray2.length);
                if (constraint.getUpdateAction() == 2) {
                    for (n = 0; n < nArray4.length; ++n) {
                        objectArray2[nArray4[n]] = null;
                    }
                } else if (constraint.getUpdateAction() == 4) {
                    for (n = 0; n < nArray4.length; ++n) {
                        Column column = table3.getColumn(nArray4[n]);
                        objectArray2[nArray4[n]] = column.getDefaultValue(session);
                    }
                    if (hashSet.add(constraint)) {
                        Table.checkCascadeUpdate(session, table3, hashMappedList, row2, objectArray2, nArray4, null, hashSet);
                        hashSet.remove(constraint);
                    }
                } else {
                    for (n = 0; n < nArray3.length; ++n) {
                        objectArray2[nArray4[n]] = objectArray[nArray3[n]];
                    }
                    if (hashSet.add(constraint)) {
                        Table.checkCascadeUpdate(session, table3, hashMappedList, row2, objectArray2, nArray2, table, hashSet);
                        hashSet.remove(constraint);
                    }
                }
                Table.mergeUpdate(hashMappedList2, row2, objectArray2, nArray4);
                row2 = rowIterator.next();
            }
        }
    }

    static void mergeUpdate(HashMappedList hashMappedList, Row row, Object[] objectArray, int[] nArray) {
        Object[] objectArray2 = (Object[])hashMappedList.get(row);
        if (objectArray2 != null) {
            for (int i = 0; i < nArray.length; ++i) {
                objectArray2[nArray[i]] = objectArray[nArray[i]];
            }
        } else {
            hashMappedList.add(row, objectArray);
        }
    }

    static boolean mergeKeepUpdate(Session session, HashMappedList hashMappedList, int[] nArray, int[] nArray2, Row row, Object[] objectArray) throws HsqlException {
        Object[] objectArray2 = (Object[])hashMappedList.get(row);
        if (objectArray2 != null) {
            if (Index.compareRows(session, row.getData(), objectArray, nArray, nArray2) != 0 && Index.compareRows(session, objectArray, objectArray2, nArray, nArray2) != 0) {
                return false;
            }
            for (int i = 0; i < nArray.length; ++i) {
                objectArray[nArray[i]] = objectArray2[nArray[i]];
            }
            hashMappedList.put(row, objectArray);
        } else {
            hashMappedList.add(row, objectArray);
        }
        return true;
    }

    static void clearUpdateLists(HashMappedList hashMappedList) {
        for (int i = 0; i < hashMappedList.size(); ++i) {
            HashMappedList hashMappedList2 = (HashMappedList)hashMappedList.get(i);
            hashMappedList2.clear();
        }
    }

    int delete(Session session, HsqlArrayList hsqlArrayList) throws HsqlException {
        HashMappedList hashMappedList;
        Object object;
        int n;
        HashSet hashSet = this.constraintPath == null ? new HashSet() : this.constraintPath;
        this.constraintPath = null;
        HashMappedList hashMappedList2 = this.tableUpdateList == null ? new HashMappedList() : this.tableUpdateList;
        this.tableUpdateList = null;
        if (this.database.isReferentialIntegrity()) {
            for (n = 0; n < hsqlArrayList.size(); ++n) {
                object = (Row)hsqlArrayList.get(n);
                hashSet.clear();
                Table.checkCascadeDelete(session, this, hashMappedList2, (Row)object, false, hashSet);
            }
        }
        this.database.txManager.checkDelete(session, hsqlArrayList);
        for (n = 0; n < hashMappedList2.size(); ++n) {
            object = (Table)hashMappedList2.getKey(n);
            hashMappedList = (HashMappedList)hashMappedList2.get(n);
            this.database.txManager.checkDelete(session, hashMappedList);
        }
        this.fireAll(session, 4);
        if (this.database.isReferentialIntegrity()) {
            for (n = 0; n < hsqlArrayList.size(); ++n) {
                object = (Row)hsqlArrayList.get(n);
                hashSet.clear();
                Table.checkCascadeDelete(session, this, hashMappedList2, (Row)object, true, hashSet);
            }
        }
        for (n = 0; n < hsqlArrayList.size(); ++n) {
            object = (Row)hsqlArrayList.get(n);
            if (((Row)object).isCascadeDeleted()) continue;
            this.deleteNoRefCheck(session, (Row)object);
        }
        for (n = 0; n < hashMappedList2.size(); ++n) {
            object = (Table)hashMappedList2.getKey(n);
            hashMappedList = (HashMappedList)hashMappedList2.get(n);
            ((Table)object).updateRowSet(session, hashMappedList, null, false);
            hashMappedList.clear();
        }
        this.fireAll(session, 1);
        hashSet.clear();
        this.constraintPath = hashSet;
        this.tableUpdateList = hashMappedList2;
        return hsqlArrayList.size();
    }

    private void deleteNoRefCheck(Session session, Row row) throws HsqlException {
        Object[] objectArray = row.getData();
        this.fireAll(session, 10, objectArray, null);
        this.deleteNoCheck(session, row, true);
        this.fireAll(session, 7, objectArray, null);
    }

    private void deleteNoCheck(Session session, Row row, boolean bl) throws HsqlException {
        if (row.isCascadeDeleted()) {
            return;
        }
        Object[] objectArray = row.getData();
        row = row.getUpdatedRow();
        for (int i = this.indexList.length - 1; i >= 0; --i) {
            Node node = row.getNode(i);
            this.indexList[i].delete(session, node);
        }
        row.delete();
        if (session != null) {
            session.addDeleteAction(this, row);
        }
        if (bl && this.isLogged) {
            this.database.logger.writeDeleteStatement(session, this, objectArray);
        }
    }

    public void deleteNoCheckFromLog(Session session, Object[] objectArray) throws HsqlException {
        Object object;
        RowIterator rowIterator;
        Row row = null;
        if (this.hasPrimaryKey()) {
            rowIterator = this.getPrimaryIndex().findFirstRow(session, objectArray, this.primaryKeyColsSequence);
            row = rowIterator.next();
        } else if (this.bestIndex == null) {
            rowIterator = this.getPrimaryIndex().firstRow(session);
            while ((row = rowIterator.next()) != null && Index.compareRows(session, row.getData(), objectArray, this.defaultColumnMap, this.colTypes) != 0) {
            }
        } else {
            rowIterator = this.bestIndex.findFirstRow(session, objectArray);
            while ((row = rowIterator.next()) != null) {
                object = row.getData();
                if (this.bestIndex.compareRowNonUnique(session, objectArray, this.bestIndex.getColumns(), (Object[])object) != 0) {
                    row = null;
                    break;
                }
                if (Index.compareRows(session, object, objectArray, this.defaultColumnMap, this.colTypes) != 0) continue;
                break;
            }
        }
        if (row == null) {
            return;
        }
        this.database.txManager.checkDelete(session, row);
        for (int i = this.indexList.length - 1; i >= 0; --i) {
            object = row.getNode(i);
            this.indexList[i].delete(session, (Node)object);
        }
        row.delete();
        if (session != null) {
            session.addDeleteAction(this, row);
        }
    }

    void deleteNoCheckRollback(Session session, Row row, boolean bl) throws HsqlException {
        row = this.indexList[0].findRow(session, row);
        for (int i = this.indexList.length - 1; i >= 0; --i) {
            Node node = row.getNode(i);
            this.indexList[i].delete(session, node);
        }
        row.delete();
        this.removeRowFromStore(row);
        if (bl && this.isLogged) {
            this.database.logger.writeDeleteStatement(session, this, row.getData());
        }
    }

    int update(Session session, HashMappedList hashMappedList, int[] nArray) throws HsqlException {
        int n;
        Object object;
        Object object2;
        Object[] objectArray;
        int n2;
        HashSet hashSet = this.constraintPath == null ? new HashSet() : this.constraintPath;
        this.constraintPath = null;
        HashMappedList hashMappedList2 = this.tableUpdateList == null ? new HashMappedList() : this.tableUpdateList;
        this.tableUpdateList = null;
        for (n2 = 0; n2 < hashMappedList.size(); ++n2) {
            objectArray = (Object[])hashMappedList.get(n2);
            this.setIdentityColumn(session, objectArray);
            this.enforceFieldValueLimits(objectArray, nArray);
            this.enforceNullConstraints(objectArray);
        }
        if (this.database.isReferentialIntegrity()) {
            for (n2 = 0; n2 < hashMappedList.size(); ++n2) {
                objectArray = (Object[])hashMappedList.get(n2);
                object2 = (Row)hashMappedList.getKey(n2);
                Table.checkCascadeUpdate(session, this, hashMappedList2, (Row)object2, objectArray, nArray, null, hashSet);
            }
        }
        this.fireAll(session, 5);
        HashMappedList hashMappedList3 = (HashMappedList)hashMappedList2.get(this);
        if (hashMappedList3 != null) {
            for (int i = 0; i < hashMappedList3.size(); ++i) {
                object2 = (Row)hashMappedList3.getKey(i);
                object = (Object[])hashMappedList3.get(i);
                Table.mergeKeepUpdate(session, hashMappedList, nArray, this.colTypes, (Row)object2, (Object[])object);
            }
            hashMappedList3.clear();
        }
        for (n = 0; n < hashMappedList2.size(); ++n) {
            object2 = (Table)hashMappedList2.getKey(n);
            object = (Object[])hashMappedList2.get(n);
            this.database.txManager.checkDelete(session, (HashMappedList)object);
        }
        this.database.txManager.checkDelete(session, hashMappedList);
        for (n = 0; n < hashMappedList2.size(); ++n) {
            object2 = (Table)hashMappedList2.getKey(n);
            object = (HashMappedList)hashMappedList2.get(n);
            ((Table)object2).updateRowSet(session, (HashMappedList)object, null, false);
            ((BaseHashMap)object).clear();
        }
        this.updateRowSet(session, hashMappedList, nArray, true);
        this.fireAll(session, 2);
        hashSet.clear();
        this.constraintPath = hashSet;
        this.tableUpdateList = hashMappedList2;
        Table.clearUpdateLists(this.tableUpdateList);
        return hashMappedList.size();
    }

    void updateRowSet(Session session, HashMappedList hashMappedList, int[] nArray, boolean bl) throws HsqlException {
        Object[] objectArray;
        Row row;
        int n;
        for (n = hashMappedList.size() - 1; n >= 0; --n) {
            row = (Row)hashMappedList.getKey(n);
            objectArray = (Object[])hashMappedList.get(n);
            if (row.isCascadeDeleted()) {
                if (bl) {
                    throw Trace.error(199);
                }
                hashMappedList.remove(n);
                continue;
            }
            for (int i = 0; i < this.constraintList.length; ++i) {
                Constraint constraint = this.constraintList[i];
                if (constraint.getType() != 3) continue;
                constraint.checkCheckConstraint(session, objectArray);
            }
            this.deleteNoCheck(session, row, true);
        }
        for (n = 0; n < hashMappedList.size(); ++n) {
            row = (Row)hashMappedList.getKey(n);
            objectArray = (Object[])hashMappedList.get(n);
            if (this.triggerLists[11] != null) {
                this.fireAll(session, 11, row.getData(), objectArray);
                this.checkRowDataUpdate(session, objectArray, nArray);
            }
            this.insertNoCheck(session, objectArray);
            if (this.triggerLists[8] == null) continue;
            this.fireAll(session, 8, row.getData(), objectArray);
            this.checkRowDataUpdate(session, objectArray, nArray);
        }
    }

    void checkRowDataInsert(Session session, Object[] objectArray) throws HsqlException {
        this.enforceFieldValueLimits(objectArray, null);
        this.enforceNullConstraints(objectArray);
        if (this.database.isReferentialIntegrity()) {
            int n = this.constraintList.length;
            for (int i = 0; i < n; ++i) {
                this.constraintList[i].checkInsert(session, objectArray);
            }
        }
    }

    void checkRowDataUpdate(Session session, Object[] objectArray, int[] nArray) throws HsqlException {
        this.enforceFieldValueLimits(objectArray, nArray);
        this.enforceNullConstraints(objectArray);
        for (int i = 0; i < this.constraintList.length; ++i) {
            Constraint constraint = this.constraintList[i];
            if (constraint.getType() != 3) continue;
            constraint.checkCheckConstraint(session, objectArray);
        }
    }

    public boolean isCached() {
        return this.isCached;
    }

    boolean isIndexCached() {
        return this.isCached;
    }

    int getIndexIndex(String string) {
        Index[] indexArray = this.indexList;
        for (int i = 0; i < indexArray.length; ++i) {
            if (!string.equals(indexArray[i].getName().name)) continue;
            return i;
        }
        return -1;
    }

    Index getIndex(String string) {
        Index[] indexArray = this.indexList;
        int n = this.getIndexIndex(string);
        return n == -1 ? null : indexArray[n];
    }

    int getConstraintIndex(String string) {
        int n = this.constraintList.length;
        for (int i = 0; i < n; ++i) {
            if (!this.constraintList[i].getName().name.equals(string)) continue;
            return i;
        }
        return -1;
    }

    Constraint getConstraint(String string) {
        int n = this.getConstraintIndex(string);
        return n < 0 ? null : this.constraintList[n];
    }

    void removeConstraint(String string) {
        int n = this.getConstraintIndex(string);
        this.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.constraintList, null, n, -1);
    }

    Column getColumn(int n) {
        return (Column)this.columnList.get(n);
    }

    void renameColumn(Column column, String string, boolean bl) throws HsqlException {
        String string2 = column.columnName.name;
        int n = this.getColumnNr(string2);
        this.columnList.setKey(n, string);
        column.columnName.rename(string, bl);
        this.renameColumnInCheckConstraints(string2, string, bl);
    }

    public int[] getColumnTypes() {
        return this.colTypes;
    }

    public Index getIndex(int n) {
        return this.indexList[n];
    }

    public Index[] getIndexes() {
        return this.indexList;
    }

    CachedRow getRow(int n, Node node) throws HsqlException {
        if (this.isText) {
            CachedDataRow cachedDataRow = (CachedDataRow)this.rowStore.get(n);
            cachedDataRow.nPrimaryNode = node;
            return cachedDataRow;
        }
        if (this.isCached) {
            return (CachedRow)this.rowStore.get(n);
        }
        return null;
    }

    CachedRow getRow(int n) {
        return (CachedRow)this.rowStore.get(n);
    }

    CachedRow getRow(long l) {
        return (CachedRow)this.rowStore.get((int)l);
    }

    void registerRow(CachedRow cachedRow) {
    }

    void removeRowFromPersistence(Row row) {
        if (this.isText && this.cache != null) {
            this.rowStore.removePersistence(row.getPos());
        }
    }

    void removeRowFromStore(Row row) throws HsqlException {
        if (this.isCached || this.isText && this.cache != null) {
            this.rowStore.remove(row.getPos());
        }
    }

    void releaseRowFromStore(Row row) throws HsqlException {
        if (this.isCached || this.isText && this.cache != null) {
            this.rowStore.release(row.getPos());
        }
    }

    void commitRowToStore(Row row) {
        if (this.isText && this.cache != null) {
            this.rowStore.commit(row);
        }
    }

    void indexRow(Session session, Row row) throws HsqlException {
        int n;
        try {
            for (n = 0; n < this.indexList.length; ++n) {
                this.indexList[n].insert(session, row, n);
            }
        }
        catch (HsqlException hsqlException) {
            --n;
            while (n >= 0) {
                Node node = row.getNode(n);
                this.indexList[n].delete(session, node);
                --n;
            }
            row.delete();
            this.removeRowFromStore(row);
            throw hsqlException;
        }
    }

    void clearAllRows(Session session) {
        for (int i = 0; i < this.indexList.length; ++i) {
            this.indexList[i].clearAll(session);
        }
        if (!this.isTemp) {
            this.identitySequence.reset();
            this.rowIdSequence.reset();
        }
    }

    void drop() throws HsqlException {
    }

    boolean isWritable() {
        return !this.isReadOnly && !this.database.databaseReadOnly && (!this.database.isFilesReadOnly() || !this.isCached && !this.isText);
    }

    String getCatalogName() {
        return this.database.getProperties().isPropertyTrue("hsqldb.catalogs") ? this.database.getURI() : null;
    }

    public String getSchemaName() {
        return this.tableName.schema.name;
    }

    public int getRowCount(Session session) throws HsqlException {
        return this.getPrimaryIndex().size(session);
    }

    public void resetRowId(Session session) throws HsqlException {
        if (this.isCached) {
            return;
        }
        this.rowIdSequence = new NumberSequence(null, 0L, 1L, -5);
        RowIterator rowIterator = this.getPrimaryIndex().firstRow(session);
        while (rowIterator.hasNext()) {
            Row row = rowIterator.next();
            int n = (int)this.rowIdSequence.getValue();
            row.setPos(n);
        }
    }

    Row newRow(Object[] objectArray) throws HsqlException {
        Row row;
        try {
            if (this.isMemory) {
                row = new Row(this, objectArray);
                int n = (int)this.rowIdSequence.getValue();
                row.setPos(n);
            } else {
                row = CachedRow.newCachedRow(this, objectArray);
                this.rowStore.add(row);
            }
        }
        catch (IOException iOException) {
            throw new HsqlException(iOException, Trace.getMessage(98), 98);
        }
        return row;
    }

    Row restoreRow(Row row) throws HsqlException {
        Row row2;
        try {
            if (this.isMemory) {
                row2 = new Row(this, row.oData);
                row2.setPos(row.getPos());
            } else {
                row2 = CachedRow.newCachedRow(this, row.oData);
                row2.setStorageSize(row.getStorageSize());
                row2.setPos(row.getPos());
                this.rowStore.restore(row2);
            }
        }
        catch (IOException iOException) {
            throw new HsqlException(iOException, Trace.getMessage(98), 98);
        }
        return row2;
    }

    public class RowStore
    implements PersistentStore {
        public CachedObject get(int n) {
            try {
                return Table.this.cache.get(n, this, false);
            }
            catch (HsqlException hsqlException) {
                return null;
            }
        }

        public CachedObject getKeep(int n) {
            try {
                return Table.this.cache.get(n, this, true);
            }
            catch (HsqlException hsqlException) {
                return null;
            }
        }

        public int getStorageSize(int n) {
            try {
                return Table.this.cache.get(n, this, false).getStorageSize();
            }
            catch (HsqlException hsqlException) {
                return 0;
            }
        }

        public void add(CachedObject cachedObject) throws IOException {
            Table.this.cache.add(cachedObject);
        }

        public void restore(CachedObject cachedObject) throws IOException {
            Table.this.cache.restore(cachedObject);
        }

        public CachedObject get(RowInputInterface rowInputInterface) {
            try {
                if (Table.this.isText) {
                    return new CachedDataRow(Table.this, rowInputInterface);
                }
                CachedRow cachedRow = new CachedRow(Table.this, rowInputInterface);
                return cachedRow;
            }
            catch (HsqlException hsqlException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public CachedObject getNewInstance(int n) {
            return null;
        }

        public void remove(int n) {
            try {
                Table.this.cache.remove(n, this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void removePersistence(int n) {
            try {
                Table.this.cache.removePersistence(n, this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void release(int n) {
            Table.this.cache.release(n);
        }

        public void commit(CachedObject cachedObject) {
            try {
                if (Table.this.isText) {
                    Table.this.cache.saveRow(cachedObject);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

