/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.util.Configuration;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public class StyleKeyRegistry {
    private static StyleKeyRegistry registry;
    private HashMap knownStyleKeys = new HashMap();
    static /* synthetic */ Class class$org$jfree$layouting$input$style$StyleKeyRegistry;
    static /* synthetic */ Class class$org$jfree$layouting$input$style$StyleKey;

    public static synchronized StyleKeyRegistry getRegistry() {
        if (registry == null) {
            registry = new StyleKeyRegistry();
            registry.registerDefaults();
        }
        return registry;
    }

    private StyleKeyRegistry() {
    }

    public StyleKey findKeyByName(String name) {
        return (StyleKey)this.knownStyleKeys.get(name);
    }

    public int getIndexForKey(StyleKey key) {
        Integer index = (Integer)this.knownStyleKeys.get(key.getName());
        if (index != null) {
            return index;
        }
        throw new IllegalStateException("This key is not registered. How could that be?");
    }

    public int getKeyCount() {
        return this.knownStyleKeys.size();
    }

    public synchronized void registerDefaults() {
        Configuration config = LibLayoutBoot.getInstance().getGlobalConfig();
        Iterator it = config.findPropertyKeys("org.jfree.layouting.stylekeys.");
        ClassLoader classLoader = ObjectUtilities.getClassLoader((Class)(class$org$jfree$layouting$input$style$StyleKeyRegistry == null ? (class$org$jfree$layouting$input$style$StyleKeyRegistry = StyleKeyRegistry.class$("org.jfree.layouting.input.style.StyleKeyRegistry")) : class$org$jfree$layouting$input$style$StyleKeyRegistry));
        while (it.hasNext()) {
            String key = (String)it.next();
            try {
                Class<?> c = classLoader.loadClass(config.getConfigProperty(key));
                this.registerClass(c);
            }
            catch (ClassNotFoundException e) {
            }
            catch (NullPointerException e) {}
        }
    }

    public synchronized void registerClass(Class c) {
        try {
            Field[] fields = c.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) continue;
                if (!Modifier.isFinal(modifiers)) {
                    Log.warn((Object)("Invalid implementation: StyleKeys should be 'public static final': " + c));
                }
                if (!field.getType().isAssignableFrom(class$org$jfree$layouting$input$style$StyleKey == null ? StyleKeyRegistry.class$("org.jfree.layouting.input.style.StyleKey") : class$org$jfree$layouting$input$style$StyleKey)) continue;
                StyleKey value = (StyleKey)field.get(null);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public synchronized StyleKey createKey(String name, boolean trans, boolean inherited, int validity) {
        StyleKey existingKey = this.findKeyByName(name);
        if (existingKey != null) {
            return existingKey;
        }
        StyleKey createdKey = new StyleKey(name, trans, inherited, this.knownStyleKeys.size(), validity);
        this.knownStyleKeys.put(name, createdKey);
        return createdKey;
    }

    public synchronized StyleKey[] getKeys() {
        return this.getKeys(new StyleKey[this.knownStyleKeys.size()]);
    }

    public synchronized StyleKey[] getKeys(StyleKey[] input) {
        return this.knownStyleKeys.values().toArray(input);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

