/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jfree.layouting.input.style.StyleRule;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceManager;

public class StyleSheet
implements Cloneable,
Serializable {
    private transient ResourceManager resourceManager;
    private transient Map roNamespaces;
    private boolean readOnly;
    private ResourceKey source;
    private ArrayList rules = new ArrayList();
    private ArrayList styleSheets = new ArrayList();
    private HashMap namespaces = new HashMap();

    public synchronized boolean isReadOnly() {
        return this.readOnly;
    }

    protected synchronized void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public ResourceKey getSource() {
        return this.source;
    }

    public synchronized void setSource(ResourceKey href) {
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        this.source = href;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceManager();
            this.resourceManager.registerDefaults();
        }
        return this.resourceManager;
    }

    public synchronized void addRule(StyleRule rule) {
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        this.rules.add(rule);
    }

    public synchronized void insertRule(int index, StyleRule rule) {
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        this.rules.add(index, rule);
    }

    public synchronized void deleteRule(int index) {
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        this.rules.remove(index);
    }

    public synchronized int getRuleCount() {
        return this.rules.size();
    }

    public synchronized StyleRule getRule(int index) {
        return (StyleRule)this.rules.get(index);
    }

    public synchronized void addStyleSheet(StyleSheet styleSheet) {
        this.styleSheets.add(styleSheet);
    }

    public synchronized int getStyleSheetCount() {
        return this.styleSheets.size();
    }

    public synchronized StyleSheet getStyleSheet(int index) {
        return (StyleSheet)this.styleSheets.get(index);
    }

    public synchronized void removeStyleSheet(StyleSheet styleSheet) {
        this.styleSheets.remove(styleSheet);
    }

    public synchronized void addNamespace(String prefix, String uri) {
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        if (prefix == null) {
            throw new NullPointerException();
        }
        if (uri == null) {
            throw new NullPointerException();
        }
        this.namespaces.put(prefix, uri);
        this.roNamespaces = null;
    }

    public synchronized String getNamespaceURI(String prefix) {
        return (String)this.namespaces.get(prefix);
    }

    public synchronized String[] getNamespacePrefixes() {
        return this.namespaces.keySet().toArray(new String[this.namespaces.size()]);
    }

    public synchronized Map getNamespaces() {
        if (this.roNamespaces == null) {
            this.roNamespaces = Collections.unmodifiableMap(this.namespaces);
        }
        return this.roNamespaces;
    }

    public Object clone() throws CloneNotSupportedException {
        StyleSheet styleSheet = (StyleSheet)super.clone();
        return styleSheet;
    }
}

