/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import org.jfree.layouting.input.style.CSSPageRule;
import org.jfree.layouting.input.style.StyleSheet;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.page.PageStyleKeys;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;

public class StyleSheetUtility {
    private StyleSheetUtility() {
    }

    public static CSSPageRule createRuleForPage(StyleSheet style, PageFormat format) {
        CSSPageRule rule = new CSSPageRule(style, null, null, null);
        StyleSheetUtility.updateRuleForPage(rule, format);
        return rule;
    }

    public static void updateRuleForPage(CSSPageRule rule, PageFormat format) {
        if (format == null) {
            rule.removeProperty(BoxStyleKeys.MARGIN_TOP);
            rule.removeProperty(BoxStyleKeys.MARGIN_LEFT);
            rule.removeProperty(BoxStyleKeys.MARGIN_BOTTOM);
            rule.removeProperty(BoxStyleKeys.MARGIN_RIGHT);
            rule.removeProperty(PageStyleKeys.SIZE);
            rule.removeProperty(PageStyleKeys.HORIZONTAL_PAGE_SPAN);
            rule.removeProperty(PageStyleKeys.VERTICAL_PAGE_SPAN);
            return;
        }
        double width = format.getWidth();
        double height = format.getHeight();
        rule.setPropertyValueAsString(PageStyleKeys.SIZE, width + "pt " + height + "pt");
        rule.setPropertyValueAsString(BoxStyleKeys.MARGIN_TOP, format.getImageableY() + "pt");
        rule.setPropertyValueAsString(BoxStyleKeys.MARGIN_LEFT, format.getImageableX() + "pt");
        double marginRight = width - format.getImageableX() - format.getImageableWidth();
        double marginBottom = height - format.getImageableY() - format.getImageableHeight();
        rule.setPropertyValueAsString(BoxStyleKeys.MARGIN_BOTTOM, marginBottom + "pt");
        rule.setPropertyValueAsString(BoxStyleKeys.MARGIN_RIGHT, marginRight + "pt");
        rule.setPropertyValueAsString(PageStyleKeys.HORIZONTAL_PAGE_SPAN, "1");
        rule.setPropertyValueAsString(PageStyleKeys.VERTICAL_PAGE_SPAN, "1");
    }

    public static PageFormat getPageFormat(CSSPageRule rule) {
        CSSValue sizeValue = rule.getPropertyCSSValue(PageStyleKeys.SIZE);
        if (!(sizeValue instanceof CSSValuePair)) {
            return null;
        }
        CSSValuePair sizePair = (CSSValuePair)sizeValue;
        CSSValue firstValue = sizePair.getFirstValue();
        CSSValue secondValue = sizePair.getSecondValue();
        double width = CSSValueResolverUtility.convertLengthToDouble(firstValue);
        double height = CSSValueResolverUtility.convertLengthToDouble(secondValue);
        if (width == 0.0 || height == 0.0) {
            return null;
        }
        double marginLeft = CSSValueResolverUtility.convertLengthToDouble(rule.getPropertyCSSValue(BoxStyleKeys.MARGIN_LEFT));
        double marginTop = CSSValueResolverUtility.convertLengthToDouble(rule.getPropertyCSSValue(BoxStyleKeys.MARGIN_TOP));
        double marginRight = CSSValueResolverUtility.convertLengthToDouble(rule.getPropertyCSSValue(BoxStyleKeys.MARGIN_RIGHT));
        double marginBottom = CSSValueResolverUtility.convertLengthToDouble(rule.getPropertyCSSValue(BoxStyleKeys.MARGIN_BOTTOM));
        if (width < height) {
            Paper p = new Paper();
            p.setSize(width, height);
            p.setImageableArea(marginLeft, marginRight, width - marginLeft - marginRight, height - marginTop - marginBottom);
            PageFormat pageFormat = new PageFormat();
            pageFormat.setPaper(p);
            pageFormat.setOrientation(1);
            return pageFormat;
        }
        Paper p = new Paper();
        p.setSize(height, width);
        p.setImageableArea(marginLeft, marginRight, width - marginLeft - marginRight, height - marginTop - marginBottom);
        PageFormat pageFormat = new PageFormat();
        pageFormat.setPaper(p);
        pageFormat.setOrientation(0);
        return pageFormat;
    }
}

