/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.input.style.CSSDeclarationRule;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.StyleKeyRegistry;
import org.jfree.layouting.input.style.parser.CSSCompoundValueReadHandler;
import org.jfree.layouting.input.style.parser.CSSParserFactoryException;
import org.jfree.layouting.input.style.parser.CSSValueReadHandler;
import org.jfree.layouting.input.style.parser.StyleSheetParserUtil;
import org.jfree.layouting.input.style.values.CSSAttrFunction;
import org.jfree.layouting.input.style.values.CSSCompoundAttrFunction;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSInheritValue;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSStringType;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.util.Configuration;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;
import org.w3c.css.sac.LexicalUnit;

public class CSSValueFactory {
    public static final String SIMPLE_PREFIX = "org.jfree.layouting.parser.handlers.";
    public static final String COMPOUND_PREFIX = "org.jfree.layouting.parser.compoundhandlers.";
    private HashMap handlers;
    private HashMap compoundHandlers;
    private StyleKeyRegistry registry;
    static /* synthetic */ Class class$org$jfree$layouting$input$style$parser$CSSValueFactory;
    static /* synthetic */ Class class$org$jfree$layouting$input$style$parser$CSSValueReadHandler;
    static /* synthetic */ Class class$org$jfree$layouting$input$style$parser$CSSCompoundValueReadHandler;

    public CSSValueFactory(StyleKeyRegistry registry) {
        if (registry == null) {
            throw new NullPointerException();
        }
        this.registry = registry;
        this.handlers = new HashMap();
        this.compoundHandlers = new HashMap();
        this.registerDefaults();
    }

    public void registerDefaults() {
        Configuration config = LibLayoutBoot.getInstance().getGlobalConfig();
        Iterator sit = config.findPropertyKeys(SIMPLE_PREFIX);
        while (sit.hasNext()) {
            String key = (String)sit.next();
            String name = key.substring(SIMPLE_PREFIX.length()).toLowerCase();
            String c = config.getConfigProperty(key);
            Object module = ObjectUtilities.loadAndInstantiate((String)c, (Class)(class$org$jfree$layouting$input$style$parser$CSSValueFactory == null ? CSSValueFactory.class$("org.jfree.layouting.input.style.parser.CSSValueFactory") : class$org$jfree$layouting$input$style$parser$CSSValueFactory), (Class)(class$org$jfree$layouting$input$style$parser$CSSValueReadHandler == null ? CSSValueFactory.class$("org.jfree.layouting.input.style.parser.CSSValueReadHandler") : class$org$jfree$layouting$input$style$parser$CSSValueReadHandler));
            if (module instanceof CSSValueReadHandler) {
                this.handlers.put(name, module);
                continue;
            }
            Log.warn((Object)("Invalid module implementation: " + c));
        }
        Iterator cit = config.findPropertyKeys(COMPOUND_PREFIX);
        while (cit.hasNext()) {
            String key = (String)cit.next();
            String name = key.substring(COMPOUND_PREFIX.length()).toLowerCase();
            String c = config.getConfigProperty(key);
            Object module = ObjectUtilities.loadAndInstantiate((String)c, (Class)(class$org$jfree$layouting$input$style$parser$CSSValueFactory == null ? CSSValueFactory.class$("org.jfree.layouting.input.style.parser.CSSValueFactory") : class$org$jfree$layouting$input$style$parser$CSSValueFactory), (Class)(class$org$jfree$layouting$input$style$parser$CSSCompoundValueReadHandler == null ? CSSValueFactory.class$("org.jfree.layouting.input.style.parser.CSSCompoundValueReadHandler") : class$org$jfree$layouting$input$style$parser$CSSCompoundValueReadHandler));
            if (!(module instanceof CSSCompoundValueReadHandler)) continue;
            this.compoundHandlers.put(name, module);
        }
    }

    private CSSValue createValue(StyleKey key, LexicalUnit value) {
        CSSValueReadHandler module = (CSSValueReadHandler)this.handlers.get(key.getName());
        if (module == null) {
            return null;
        }
        return module.createValue(key, value);
    }

    public static CSSAttrFunction parseAttrFunction(LexicalUnit unit) {
        if (unit.getLexicalUnitType() != 37) {
            return null;
        }
        String attrName = unit.getStringValue().trim();
        String[] name = StyleSheetParserUtil.parseNamespaceIdent(attrName);
        return new CSSAttrFunction(name[0], name[1]);
    }

    public static boolean isFunctionValue(LexicalUnit unit) {
        return unit.getLexicalUnitType() == 41 || unit.getLexicalUnitType() == 25 || unit.getLexicalUnitType() == 26 || unit.getLexicalUnitType() == 27 || unit.getLexicalUnitType() == 38 || unit.getLexicalUnitType() == 41;
    }

    private static CSSAttrFunction parseComplexAttrFn(LexicalUnit parameters) {
        if (parameters == null) {
            return null;
        }
        String attrName = parameters.getStringValue().trim();
        String[] name = StyleSheetParserUtil.parseNamespaceIdent(attrName);
        LexicalUnit afterComma = CSSValueFactory.parseComma(parameters);
        if (afterComma == null) {
            return new CSSAttrFunction(name[0], name[1]);
        }
        String attrType = CSSValueFactory.parseAttributeType(afterComma);
        if (attrType == null) {
            return new CSSAttrFunction(name[0], name[1]);
        }
        return new CSSAttrFunction(name[0], name[1], attrType);
    }

    public static CSSFunctionValue parseFunction(LexicalUnit unit) {
        if (!CSSValueFactory.isFunctionValue(unit)) {
            return null;
        }
        LexicalUnit parameters = unit.getParameters();
        String functionName = unit.getFunctionName();
        if (parameters == null) {
            return new CSSFunctionValue(functionName, new CSSValue[0]);
        }
        if ("attr".equalsIgnoreCase(functionName)) {
            return CSSValueFactory.parseComplexAttrFn(unit.getParameters());
        }
        ArrayList<CSSValue> contentList = new ArrayList<CSSValue>();
        while (parameters != null) {
            if (parameters.getLexicalUnitType() == 35) {
                contentList.add(new CSSConstant(parameters.getStringValue()));
            } else if (parameters.getLexicalUnitType() == 36) {
                contentList.add(new CSSStringValue(CSSStringType.STRING, parameters.getStringValue()));
            } else if (CSSValueFactory.isNumericValue(parameters)) {
                CSSNumericValue numericValue = CSSValueFactory.createNumericValue(parameters);
                if (numericValue == null) {
                    return null;
                }
                contentList.add(numericValue);
            } else if (CSSValueFactory.isLengthValue(parameters)) {
                CSSNumericValue lengthValue = CSSValueFactory.createLengthValue(parameters);
                if (lengthValue == null) {
                    return null;
                }
                contentList.add(lengthValue);
            } else if (parameters.getLexicalUnitType() == 37) {
                CSSAttrFunction attrFn = CSSValueFactory.parseAttrFunction(parameters);
                if (attrFn == null) {
                    return null;
                }
                contentList.add(attrFn);
            } else if (parameters.getLexicalUnitType() == 24) {
                CSSStringValue uriValue = CSSValueFactory.createUriValue(parameters);
                if (uriValue == null) {
                    return null;
                }
                contentList.add(uriValue);
            } else if (CSSValueFactory.isFunctionValue(parameters)) {
                CSSFunctionValue functionValue = CSSValueFactory.parseFunction(parameters);
                if (functionValue == null) {
                    return null;
                }
                contentList.add(functionValue);
            } else {
                return null;
            }
            parameters = CSSValueFactory.parseComma(parameters);
        }
        CSSValue[] paramVals = contentList.toArray(new CSSValue[contentList.size()]);
        return new CSSFunctionValue(functionName, paramVals);
    }

    private static String parseAttributeType(LexicalUnit unit) {
        if (unit == null) {
            return null;
        }
        if (unit.getLexicalUnitType() == 35) {
            return unit.getStringValue();
        }
        return null;
    }

    private void setCompundInheritValue(String name, CSSDeclarationRule rule, boolean important) {
        CSSCompoundValueReadHandler handler = (CSSCompoundValueReadHandler)this.compoundHandlers.get(name);
        if (handler == null) {
            Log.warn((Object)("Got no key for inherited value: " + name));
            return;
        }
        StyleKey[] keys = handler.getAffectedKeys();
        for (int i = 0; i < keys.length; ++i) {
            StyleKey key = keys[i];
            rule.setPropertyValue(key, CSSInheritValue.getInstance());
            rule.setImportant(key, important);
        }
    }

    private void setCompundAttrValue(String name, CSSAttrFunction attr, CSSDeclarationRule rule, boolean important) {
        CSSCompoundValueReadHandler handler = (CSSCompoundValueReadHandler)this.compoundHandlers.get(name);
        if (handler == null) {
            Log.warn((Object)("Got no key for compound attr function: " + name));
            return;
        }
        StyleKey[] keys = handler.getAffectedKeys();
        for (int i = 0; i < keys.length; ++i) {
            StyleKey key = keys[i];
            CSSCompoundAttrFunction cattr = new CSSCompoundAttrFunction(name, attr.getNamespace(), attr.getName(), attr.getType());
            rule.setPropertyValue(key, cattr);
            rule.setImportant(key, important);
        }
    }

    public void parseValue(CSSDeclarationRule rule, String name, LexicalUnit value, boolean important) throws CSSParserFactoryException {
        CSSValue cssValue;
        if (rule == null) {
            throw new NullPointerException("Rule given is null.");
        }
        String normalizedName = name.toLowerCase();
        StyleKey key = this.registry.findKeyByName(normalizedName);
        if (value.getLexicalUnitType() == 12) {
            if (key == null) {
                this.setCompundInheritValue(normalizedName, rule, important);
                return;
            }
            rule.setPropertyValue(key, CSSInheritValue.getInstance());
            rule.setImportant(key, important);
            return;
        }
        if (value.getLexicalUnitType() == 37) {
            CSSAttrFunction attrFn = CSSValueFactory.parseAttrFunction(value);
            if (attrFn != null) {
                if (key == null) {
                    this.setCompundAttrValue(normalizedName, attrFn, rule, important);
                    return;
                }
                rule.setPropertyValue(key, attrFn);
                rule.setImportant(key, important);
            }
            return;
        }
        if (CSSValueFactory.isFunctionValue(value) && "attr".equals(value.getFunctionName())) {
            if (key == null) {
                Log.warn((Object)("Got no key for attribute-function " + normalizedName));
                return;
            }
            CSSAttrFunction attrFn = CSSValueFactory.parseComplexAttrFn(value.getParameters());
            if (attrFn != null) {
                rule.setPropertyValue(key, attrFn);
                rule.setImportant(key, important);
            }
            return;
        }
        if (key != null && (cssValue = this.createValue(key, value)) != null) {
            rule.setPropertyValue(key, cssValue);
            rule.setImportant(key, important);
            return;
        }
        CSSCompoundValueReadHandler module = (CSSCompoundValueReadHandler)this.compoundHandlers.get(normalizedName);
        if (module == null) {
            if (key == null) {
                Log.info((Object)("Unknown style-key: Neither compound handlers nor single-value handers are registered for " + normalizedName));
                return;
            }
            Log.warn((Object)("Unparsable value: Got no valid result for " + normalizedName + " (" + value + ")"));
            return;
        }
        Map map = module.createValues(value);
        if (map == null) {
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            StyleKey entryKey = (StyleKey)entry.getKey();
            CSSValue mapCssValue = (CSSValue)entry.getValue();
            rule.setPropertyValue(entryKey, mapCssValue);
            rule.setImportant(entryKey, important);
        }
    }

    public static CSSStringValue createUriValue(LexicalUnit value) {
        if (value.getLexicalUnitType() != 24) {
            return null;
        }
        String uri = value.getStringValue();
        return new CSSStringValue(CSSStringType.URI, uri);
    }

    public static boolean isNumericValue(LexicalUnit value) {
        if (value.getLexicalUnitType() == 13) {
            return true;
        }
        return value.getLexicalUnitType() == 14;
    }

    public static CSSNumericValue createNumericValue(LexicalUnit value) {
        if (value.getLexicalUnitType() == 13) {
            return CSSNumericValue.createValue(CSSNumericType.NUMBER, value.getIntegerValue());
        }
        if (value.getLexicalUnitType() == 14) {
            return CSSNumericValue.createValue(CSSNumericType.NUMBER, value.getFloatValue());
        }
        return null;
    }

    public static boolean isLengthValue(LexicalUnit value) {
        if (value.getLexicalUnitType() == 15) {
            return true;
        }
        if (value.getLexicalUnitType() == 16) {
            return true;
        }
        if (value.getLexicalUnitType() == 17) {
            return true;
        }
        if (value.getLexicalUnitType() == 18) {
            return true;
        }
        if (value.getLexicalUnitType() == 19) {
            return true;
        }
        if (value.getLexicalUnitType() == 20) {
            return true;
        }
        if (value.getLexicalUnitType() == 22) {
            return true;
        }
        return value.getLexicalUnitType() == 21;
    }

    public static CSSNumericValue createLengthValue(LexicalUnit value) {
        if (value.getLexicalUnitType() == 13) {
            if (value.getFloatValue() != 0.0f) {
                return null;
            }
            return CSSNumericValue.createValue(CSSNumericType.PT, 0.0);
        }
        if (value.getLexicalUnitType() == 15) {
            return CSSNumericValue.createValue(CSSNumericType.EM, value.getFloatValue());
        }
        if (value.getLexicalUnitType() == 16) {
            return CSSNumericValue.createValue(CSSNumericType.EX, value.getFloatValue());
        }
        if (value.getLexicalUnitType() == 17) {
            return CSSNumericValue.createValue(CSSNumericType.PX, value.getFloatValue());
        }
        if (value.getLexicalUnitType() == 18) {
            return CSSNumericValue.createValue(CSSNumericType.INCH, value.getFloatValue());
        }
        if (value.getLexicalUnitType() == 19) {
            return CSSNumericValue.createValue(CSSNumericType.CM, value.getFloatValue());
        }
        if (value.getLexicalUnitType() == 20) {
            return CSSNumericValue.createValue(CSSNumericType.MM, value.getFloatValue());
        }
        if (value.getLexicalUnitType() == 22) {
            return CSSNumericValue.createValue(CSSNumericType.PC, value.getFloatValue());
        }
        if (value.getLexicalUnitType() == 21) {
            return CSSNumericValue.createValue(CSSNumericType.PT, value.getFloatValue());
        }
        return null;
    }

    public static LexicalUnit parseComma(LexicalUnit value) {
        if (value == null) {
            return null;
        }
        LexicalUnit maybeComma = value.getNextLexicalUnit();
        if (maybeComma == null) {
            return null;
        }
        if (maybeComma.getLexicalUnitType() == 0) {
            return maybeComma.getNextLexicalUnit();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

