/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.jfree.layouting.input.style.CSSDeclarationRule;
import org.jfree.layouting.input.style.CSSStyleRule;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.StyleKeyRegistry;
import org.jfree.layouting.input.style.parser.CSSParserContext;
import org.jfree.layouting.input.style.parser.CSSParserFactory;
import org.jfree.layouting.input.style.parser.CSSParserInstantiationException;
import org.jfree.layouting.input.style.parser.StyleSheetHandler;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceManager;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SelectorList;

public final class StyleSheetParserUtil {
    private static StyleSheetParserUtil singleton;
    private Parser parser;
    private StyleKeyRegistry registry = StyleKeyRegistry.getRegistry();

    public static synchronized StyleSheetParserUtil getInstance() {
        if (singleton == null) {
            singleton = new StyleSheetParserUtil();
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectorList parseSelector(Map namespaces, String selector, ResourceManager resourceManager, ResourceKey baseURL) {
        if (selector == null) {
            throw new NullPointerException();
        }
        try {
            Parser parser;
            Parser parser2 = parser = this.getParser();
            synchronized (parser2) {
                StyleSheetHandler handler = new StyleSheetHandler();
                handler.init(resourceManager, baseURL, -1L, StyleKeyRegistry.getRegistry(), null);
                this.setupNamespaces(namespaces, handler);
                InputSource source = new InputSource();
                source.setCharacterStream((Reader)new StringReader(selector));
                handler.initParseContext(source);
                handler.setStyleRule(new CSSStyleRule(null, null));
                parser.setDocumentHandler((DocumentHandler)handler);
                SelectorList selectorList = parser.parseSelectors(source);
                CSSParserContext.getContext().destroy();
                return selectorList;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setupNamespaces(Map namespaces, StyleSheetHandler handler) {
        if (namespaces == null) {
            return;
        }
        Iterator entries = namespaces.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String prefix = (String)entry.getKey();
            String uri = (String)entry.getValue();
            handler.registerNamespace(prefix, uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSSValue parseStyleValue(Map namespaces, StyleKey key, String value, ResourceManager resourceManager, ResourceKey baseURL) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        try {
            Parser parser;
            Parser parser2 = parser = this.getParser();
            synchronized (parser2) {
                StyleSheetHandler handler = new StyleSheetHandler();
                this.setupNamespaces(namespaces, handler);
                handler.init(resourceManager, baseURL, -1L, this.registry, null);
                InputSource source = new InputSource();
                source.setCharacterStream((Reader)new StringReader(value));
                handler.initParseContext(source);
                handler.setStyleRule(new CSSStyleRule(null, null));
                parser.setDocumentHandler((DocumentHandler)handler);
                LexicalUnit lu = parser.parsePropertyValue(source);
                handler.property(key.getName(), lu, false);
                CSSStyleRule rule = (CSSStyleRule)handler.getStyleRule();
                CSSParserContext.getContext().destroy();
                return rule.getPropertyCSSValue(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LexicalUnit parseLexicalStyleValue(String value) {
        try {
            Parser parser;
            Parser parser2 = parser = this.getParser();
            synchronized (parser2) {
                StyleSheetHandler handler = new StyleSheetHandler();
                handler.init(null, null, -1L, this.registry, null);
                InputSource source = new InputSource();
                source.setCharacterStream((Reader)new StringReader(value));
                handler.initParseContext(source);
                parser.setDocumentHandler((DocumentHandler)handler);
                return parser.parsePropertyValue(source);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public CSSStyleRule parseStyles(Map namespaces, StyleKey key, String value, ResourceManager resourceManager, ResourceKey baseURL) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.parseStyles(namespaces, key.getName(), value, resourceManager, baseURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSSDeclarationRule parseStyleRule(Map namespaces, String styleText, ResourceManager resourceManager, ResourceKey baseURL, CSSDeclarationRule baseRule) {
        if (styleText == null) {
            throw new NullPointerException("Name is null");
        }
        try {
            Parser parser;
            Parser parser2 = parser = this.getParser();
            synchronized (parser2) {
                StyleSheetHandler handler = new StyleSheetHandler();
                this.setupNamespaces(namespaces, handler);
                handler.init(resourceManager, baseURL, -1L, this.registry, null);
                InputSource source = new InputSource();
                source.setCharacterStream((Reader)new StringReader(styleText));
                handler.initParseContext(source);
                handler.setStyleRule(baseRule);
                parser.setDocumentHandler((DocumentHandler)handler);
                parser.parseStyleDeclaration(source);
                CSSDeclarationRule rule = handler.getStyleRule();
                CSSParserContext.getContext().destroy();
                return rule;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public CSSStyleRule parseStyles(Map namespaces, String name, String value, ResourceManager resourceManager, ResourceKey baseURL) {
        return this.parseStyles(namespaces, name, value, resourceManager, baseURL, new CSSStyleRule(null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSSStyleRule parseStyles(Map namespaces, String name, String value, ResourceManager resourceManager, ResourceKey baseURL, CSSDeclarationRule baseRule) {
        if (name == null) {
            throw new NullPointerException("Name is null");
        }
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        try {
            Parser parser;
            Parser parser2 = parser = this.getParser();
            synchronized (parser2) {
                StyleSheetHandler handler = new StyleSheetHandler();
                handler.init(resourceManager, baseURL, -1L, StyleKeyRegistry.getRegistry(), null);
                this.setupNamespaces(namespaces, handler);
                InputSource source = new InputSource();
                source.setCharacterStream((Reader)new StringReader(value));
                handler.initParseContext(source);
                handler.setStyleRule(baseRule);
                parser.setDocumentHandler((DocumentHandler)handler);
                LexicalUnit lu = parser.parsePropertyValue(source);
                handler.property(name, lu, false);
                CSSStyleRule rule = (CSSStyleRule)handler.getStyleRule();
                CSSParserContext.getContext().destroy();
                return rule;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private synchronized Parser getParser() throws CSSParserInstantiationException {
        if (this.parser == null) {
            this.parser = CSSParserFactory.getInstance().createCSSParser();
        }
        return this.parser;
    }

    public static String[] parseNamespaceIdent(String attrName) {
        String name;
        String namespace;
        StringTokenizer strtok = new StringTokenizer(attrName, "|");
        CSSParserContext context = CSSParserContext.getContext();
        if (strtok.countTokens() == 2) {
            String tkNamespace = strtok.nextToken();
            namespace = tkNamespace.length() == 0 ? null : ("*".equals(tkNamespace) ? "*" : (String)context.getNamespaces().get(tkNamespace));
            name = strtok.nextToken();
        } else {
            name = strtok.nextToken();
            namespace = context.getDefaultNamespace();
        }
        return new String[]{namespace, name};
    }
}

